/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EyeblossomBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockFlowerPot
extends Block {
    public static final MapCodec<BlockFlowerPot> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("potted").forGetter(var0 -> var0.potted), BlockFlowerPot.propertiesCodec()).apply((Applicative)var02, BlockFlowerPot::new));
    private static final Map<Block, Block> POTTED_BY_CONTENT = Maps.newHashMap();
    private static final VoxelShape SHAPE = Block.column(6.0, 0.0, 6.0);
    private final Block potted;

    public MapCodec<BlockFlowerPot> codec() {
        return CODEC;
    }

    public BlockFlowerPot(Block var0, BlockBase.Info var1) {
        super(var1);
        this.potted = var0;
        POTTED_BY_CONTENT.put(var0, this);
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        Block block;
        Item item = var0.getItem();
        if (item instanceof ItemBlock) {
            ItemBlock var8 = (ItemBlock)item;
            block = POTTED_BY_CONTENT.getOrDefault(var8.getBlock(), Blocks.AIR);
        } else {
            block = Blocks.AIR;
        }
        IBlockData var7 = block.defaultBlockState();
        if (var7.isAir()) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        if (!this.isEmpty()) {
            return EnumInteractionResult.CONSUME;
        }
        var2.setBlock(var3, var7, 3);
        var2.gameEvent((Entity)var4, GameEvent.BLOCK_CHANGE, var3);
        var4.awardStat(StatisticList.POT_FLOWER);
        var0.consume(1, var4);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        if (this.isEmpty()) {
            return EnumInteractionResult.CONSUME;
        }
        ItemStack var5 = new ItemStack(this.potted);
        if (!var3.addItem(var5)) {
            var3.drop(var5, false);
        }
        var1.setBlock(var2, Blocks.FLOWER_POT.defaultBlockState(), 3);
        var1.gameEvent((Entity)var3, GameEvent.BLOCK_CHANGE, var2);
        return EnumInteractionResult.SUCCESS;
    }

    @Override
    protected ItemStack getCloneItemStack(IWorldReader var0, BlockPosition var1, IBlockData var2, boolean var3) {
        if (this.isEmpty()) {
            return super.getCloneItemStack(var0, var1, var2, var3);
        }
        return new ItemStack(this.potted);
    }

    private boolean isEmpty() {
        return this.potted == Blocks.AIR;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4 == EnumDirection.DOWN && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    public Block getPotted() {
        return this.potted;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return false;
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return var0.is(Blocks.POTTED_OPEN_EYEBLOSSOM) || var0.is(Blocks.POTTED_CLOSED_EYEBLOSSOM);
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        boolean var5;
        boolean var4;
        if (this.isRandomlyTicking(var0) && (var4 = this.potted == Blocks.OPEN_EYEBLOSSOM) != (var5 = var1.environmentAttributes().getValue(EnvironmentAttributes.EYEBLOSSOM_OPEN, var2).toBoolean(var4))) {
            var1.setBlock(var2, this.opposite(var0), 3);
            EyeblossomBlock.a var6 = EyeblossomBlock.a.fromBoolean(var4).transform();
            var6.spawnTransformParticle(var1, var2, var3);
            var1.playSound(null, var2, var6.longSwitchSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(var0, var1, var2, var3);
    }

    public IBlockData opposite(IBlockData var0) {
        if (var0.is(Blocks.POTTED_OPEN_EYEBLOSSOM)) {
            return Blocks.POTTED_CLOSED_EYEBLOSSOM.defaultBlockState();
        }
        if (var0.is(Blocks.POTTED_CLOSED_EYEBLOSSOM)) {
            return Blocks.POTTED_OPEN_EYEBLOSSOM.defaultBlockState();
        }
        return var0;
    }
}

