/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypeFlowing;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockFluids
extends Block
implements IFluidSource {
    private static final Codec<FluidTypeFlowing> FLOWING_FLUID = BuiltInRegistries.FLUID.byNameCodec().comapFlatMap(var0 -> {
        DataResult dataResult;
        if (var0 instanceof FluidTypeFlowing) {
            FluidTypeFlowing var1 = (FluidTypeFlowing)var0;
            dataResult = DataResult.success((Object)var1);
        } else {
            dataResult = DataResult.error(() -> "Not a flowing fluid: " + String.valueOf(var0));
        }
        return dataResult;
    }, var0 -> var0);
    public static final MapCodec<BlockFluids> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)FLOWING_FLUID.fieldOf("fluid").forGetter(var0 -> var0.fluid), BlockFluids.propertiesCodec()).apply((Applicative)var02, BlockFluids::new));
    public static final BlockStateInteger LEVEL = BlockProperties.LEVEL;
    protected final FluidTypeFlowing fluid;
    private final List<Fluid> stateCache;
    public static final VoxelShape SHAPE_STABLE = Block.column(16.0, 0.0, 8.0);
    public static final ImmutableList<EnumDirection> POSSIBLE_FLOW_DIRECTIONS = ImmutableList.of((Object)EnumDirection.DOWN, (Object)EnumDirection.SOUTH, (Object)EnumDirection.NORTH, (Object)EnumDirection.EAST, (Object)EnumDirection.WEST);

    public MapCodec<BlockFluids> codec() {
        return CODEC;
    }

    protected BlockFluids(FluidTypeFlowing var0, BlockBase.Info var1) {
        super(var1);
        this.fluid = var0;
        this.stateCache = Lists.newArrayList();
        this.stateCache.add(var0.getSource(false));
        for (int var2 = 1; var2 < 8; ++var2) {
            this.stateCache.add(var0.getFlowing(8 - var2, false));
        }
        this.stateCache.add(var0.getFlowing(8, true));
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(LEVEL, 0));
    }

    @Override
    protected VoxelShape getCollisionShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        if (var3.alwaysCollideWithFluid()) {
            return VoxelShapes.block();
        }
        if (var3.isAbove(SHAPE_STABLE, var2, true) && var0.getValue(LEVEL) == 0 && var3.canStandOnFluid(var1.getFluidState(var2.above()), var0.getFluidState())) {
            return SHAPE_STABLE;
        }
        return VoxelShapes.empty();
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return var0.getFluidState().isRandomlyTicking();
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        var0.getFluidState().randomTick(var1, var2, var3);
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return false;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return !this.fluid.is(TagsFluid.LAVA);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        int var1 = var0.getValue(LEVEL);
        return this.stateCache.get(Math.min(var1, 8));
    }

    @Override
    protected boolean skipRendering(IBlockData var0, IBlockData var1, EnumDirection var2) {
        return var1.getFluidState().getType().isSame(this.fluid);
    }

    @Override
    protected EnumRenderType getRenderShape(IBlockData var0) {
        return EnumRenderType.INVISIBLE;
    }

    @Override
    protected List<ItemStack> getDrops(IBlockData var0, LootParams.a var1) {
        return Collections.emptyList();
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return VoxelShapes.empty();
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (this.shouldSpreadLiquid(var1, var2, var0)) {
            var1.scheduleTick(var2, var0.getFluidState().getType(), this.fluid.getTickDelay(var1));
        }
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getFluidState().isSource() || var6.getFluidState().isSource()) {
            var2.scheduleTick(var3, var0.getFluidState().getType(), this.fluid.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (this.shouldSpreadLiquid(var1, var2, var0)) {
            var1.scheduleTick(var2, var0.getFluidState().getType(), this.fluid.getTickDelay(var1));
        }
    }

    private boolean shouldSpreadLiquid(World var0, BlockPosition var1, IBlockData var2) {
        if (this.fluid.is(TagsFluid.LAVA)) {
            boolean var3 = var0.getBlockState(var1.below()).is(Blocks.SOUL_SOIL);
            for (EnumDirection var5 : POSSIBLE_FLOW_DIRECTIONS) {
                BlockPosition var6 = var1.relative(var5.getOpposite());
                if (var0.getFluidState(var6).is(TagsFluid.WATER)) {
                    Block var7 = var0.getFluidState(var1).isSource() ? Blocks.OBSIDIAN : Blocks.COBBLESTONE;
                    var0.setBlockAndUpdate(var1, var7.defaultBlockState());
                    this.fizz(var0, var1);
                    return false;
                }
                if (!var3 || !var0.getBlockState(var6).is(Blocks.BLUE_ICE)) continue;
                var0.setBlockAndUpdate(var1, Blocks.BASALT.defaultBlockState());
                this.fizz(var0, var1);
                return false;
            }
        }
        return true;
    }

    private void fizz(GeneratorAccess var0, BlockPosition var1) {
        var0.levelEvent(1501, var1, 0);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(LEVEL);
    }

    @Override
    public ItemStack pickupBlock(@Nullable EntityLiving var0, GeneratorAccess var1, BlockPosition var2, IBlockData var3) {
        if (var3.getValue(LEVEL) == 0) {
            var1.setBlock(var2, Blocks.AIR.defaultBlockState(), 11);
            return new ItemStack(this.fluid.getBucket());
        }
        return ItemStack.EMPTY;
    }

    @Override
    public Optional<SoundEffect> getPickupSound() {
        return this.fluid.getPickupSound();
    }
}

