/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.jspecify.annotations.Nullable;

public abstract class BlockGrowingAbstract
extends Block {
    protected final EnumDirection growthDirection;
    protected final boolean scheduleFluidTicks;
    protected final VoxelShape shape;

    protected BlockGrowingAbstract(BlockBase.Info var0, EnumDirection var1, VoxelShape var2, boolean var3) {
        super(var0);
        this.growthDirection = var1;
        this.shape = var2;
        this.scheduleFluidTicks = var3;
    }

    protected abstract MapCodec<? extends BlockGrowingAbstract> codec();

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        IBlockData var1 = var0.getLevel().getBlockState(var0.getClickedPos().relative(this.growthDirection));
        if (var1.is(this.getHeadBlock()) || var1.is(this.getBodyBlock())) {
            return this.getBodyBlock().defaultBlockState();
        }
        return this.getStateForPlacement(var0.getLevel().random);
    }

    public IBlockData getStateForPlacement(RandomSource var0) {
        return this.defaultBlockState();
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        BlockPosition var3 = var2.relative(this.growthDirection.getOpposite());
        IBlockData var4 = var1.getBlockState(var3);
        if (!this.canAttachTo(var4)) {
            return false;
        }
        return var4.is(this.getHeadBlock()) || var4.is(this.getBodyBlock()) || var4.isFaceSturdy(var1, var3, this.growthDirection);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var0.canSurvive(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    protected boolean canAttachTo(IBlockData var0) {
        return true;
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shape;
    }

    protected abstract BlockGrowingTop getHeadBlock();

    protected abstract Block getBodyBlock();
}

