/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJukeBox;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.jspecify.annotations.Nullable;

public class BlockJukeBox
extends BlockTileEntity {
    public static final MapCodec<BlockJukeBox> CODEC = BlockJukeBox.simpleCodec(BlockJukeBox::new);
    public static final BlockStateBoolean HAS_RECORD = BlockProperties.HAS_RECORD;

    public MapCodec<BlockJukeBox> codec() {
        return CODEC;
    }

    protected BlockJukeBox(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HAS_RECORD, false));
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        super.setPlacedBy(var0, var1, var2, var3, var4);
        TypedEntityData<TileEntityTypes<?>> var5 = var4.get(DataComponents.BLOCK_ENTITY_DATA);
        if (var5 != null && var5.contains("RecordItem")) {
            var0.setBlock(var1, (IBlockData)var2.setValue(HAS_RECORD, true), 2);
        }
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity tileEntity;
        if (var0.getValue(HAS_RECORD).booleanValue() && (tileEntity = var1.getBlockEntity(var2)) instanceof TileEntityJukeBox) {
            TileEntityJukeBox var5 = (TileEntityJukeBox)tileEntity;
            var5.popOutTheItem();
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        if (var1.getValue(HAS_RECORD).booleanValue()) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        ItemStack var7 = var4.getItemInHand(var5);
        EnumInteractionResult var8 = JukeboxPlayable.tryInsertIntoJukebox(var2, var3, var7, var4);
        if (!var8.consumesAction()) {
            return EnumInteractionResult.TRY_WITH_EMPTY_HAND;
        }
        return var8;
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityJukeBox(var0, var1);
    }

    @Override
    public boolean isSignalSource(IBlockData var0) {
        return true;
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        TileEntityJukeBox var4;
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof TileEntityJukeBox && (var4 = (TileEntityJukeBox)tileEntity).getSongPlayer().isPlaying()) {
            return 15;
        }
        return 0;
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof TileEntityJukeBox) {
            TileEntityJukeBox var4 = (TileEntityJukeBox)tileEntity;
            return var4.getComparatorOutput();
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HAS_RECORD);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> getTicker(World var0, IBlockData var1, TileEntityTypes<T> var2) {
        if (var1.getValue(HAS_RECORD).booleanValue()) {
            return BlockJukeBox.createTickerHelper(var2, TileEntityTypes.JUKEBOX, TileEntityJukeBox::tick);
        }
        return null;
    }
}

