/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.jspecify.annotations.Nullable;

public class BlockStructure
extends BlockTileEntity
implements GameMasterBlock {
    public static final MapCodec<BlockStructure> CODEC = BlockStructure.simpleCodec(BlockStructure::new);
    public static final BlockStateEnum<BlockPropertyStructureMode> MODE = BlockProperties.STRUCTUREBLOCK_MODE;

    public MapCodec<BlockStructure> codec() {
        return CODEC;
    }

    protected BlockStructure(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(MODE, BlockPropertyStructureMode.LOAD));
    }

    @Override
    public TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new TileEntityStructure(var0, var1);
    }

    @Override
    protected EnumInteractionResult useWithoutItem(IBlockData var0, World var1, BlockPosition var2, EntityHuman var3, MovingObjectPositionBlock var4) {
        TileEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof TileEntityStructure) {
            return ((TileEntityStructure)var5).usedBy(var3) ? EnumInteractionResult.SUCCESS : EnumInteractionResult.PASS;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        TileEntity var5;
        if (var0.isClientSide()) {
            return;
        }
        if (var3 != null && (var5 = var0.getBlockEntity(var1)) instanceof TileEntityStructure) {
            ((TileEntityStructure)var5).createdBy(var3);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(MODE);
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (!(var1 instanceof WorldServer)) {
            return;
        }
        TileEntity var6 = var1.getBlockEntity(var2);
        if (!(var6 instanceof TileEntityStructure)) {
            return;
        }
        TileEntityStructure var7 = (TileEntityStructure)var6;
        boolean var8 = var1.hasNeighborSignal(var2);
        boolean var9 = var7.isPowered();
        if (var8 && !var9) {
            var7.setPowered(true);
            this.trigger((WorldServer)var1, var7);
        } else if (!var8 && var9) {
            var7.setPowered(false);
        }
    }

    private void trigger(WorldServer var0, TileEntityStructure var1) {
        switch (var1.getMode()) {
            case SAVE: {
                var1.saveStructure(false);
                break;
            }
            case LOAD: {
                var1.placeStructure(var0);
                break;
            }
            case CORNER: {
                var1.unloadStructure();
                break;
            }
            case DATA: {
                break;
            }
        }
    }
}

