/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyDoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.FluidTypes;
import org.jspecify.annotations.Nullable;

public class BlockTallPlant
extends VegetationBlock {
    public static final MapCodec<BlockTallPlant> CODEC = BlockTallPlant.simpleCodec(BlockTallPlant::new);
    public static final BlockStateEnum<BlockPropertyDoubleBlockHalf> HALF = BlockProperties.DOUBLE_BLOCK_HALF;

    public MapCodec<? extends BlockTallPlant> codec() {
        return CODEC;
    }

    public BlockTallPlant(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(HALF, BlockPropertyDoubleBlockHalf.LOWER));
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        BlockPropertyDoubleBlockHalf var8 = var0.getValue(HALF);
        if (!(var4.getAxis() != EnumDirection.EnumAxis.Y || var8 == BlockPropertyDoubleBlockHalf.LOWER != (var4 == EnumDirection.UP) || var6.is(this) && var6.getValue(HALF) != var8)) {
            return Blocks.AIR.defaultBlockState();
        }
        if (var8 == BlockPropertyDoubleBlockHalf.LOWER && var4 == EnumDirection.DOWN && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        BlockPosition var1 = var0.getClickedPos();
        World var2 = var0.getLevel();
        if (var1.getY() < var2.getMaxY() && var2.getBlockState(var1.above()).canBeReplaced(var0)) {
            return super.getStateForPlacement(var0);
        }
        return null;
    }

    @Override
    public void setPlacedBy(World var0, BlockPosition var1, IBlockData var2, @Nullable EntityLiving var3, ItemStack var4) {
        BlockPosition var5 = var1.above();
        var0.setBlock(var5, BlockTallPlant.copyWaterloggedFrom(var0, var5, (IBlockData)this.defaultBlockState().setValue(HALF, BlockPropertyDoubleBlockHalf.UPPER)), 3);
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        if (var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.UPPER) {
            IBlockData var3 = var1.getBlockState(var2.below());
            return var3.is(this) && var3.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER;
        }
        return super.canSurvive(var0, var1, var2);
    }

    public static void placeAt(GeneratorAccess var0, IBlockData var1, BlockPosition var2, @Block.b int var3) {
        BlockPosition var4 = var2.above();
        var0.setBlock(var2, BlockTallPlant.copyWaterloggedFrom(var0, var2, (IBlockData)var1.setValue(HALF, BlockPropertyDoubleBlockHalf.LOWER)), var3);
        var0.setBlock(var4, BlockTallPlant.copyWaterloggedFrom(var0, var4, (IBlockData)var1.setValue(HALF, BlockPropertyDoubleBlockHalf.UPPER)), var3);
    }

    public static IBlockData copyWaterloggedFrom(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        if (var2.hasProperty(BlockProperties.WATERLOGGED)) {
            return (IBlockData)var2.setValue(BlockProperties.WATERLOGGED, var0.isWaterAt(var1));
        }
        return var2;
    }

    @Override
    public IBlockData playerWillDestroy(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        if (!var0.isClientSide()) {
            if (var3.preventsBlockDrops()) {
                BlockTallPlant.preventDropFromBottomPart(var0, var1, var2, var3);
            } else {
                BlockTallPlant.dropResources(var2, var0, var1, null, var3, var3.getMainHandItem());
            }
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    public void playerDestroy(World var0, EntityHuman var1, BlockPosition var2, IBlockData var3, @Nullable TileEntity var4, ItemStack var5) {
        super.playerDestroy(var0, var1, var2, Blocks.AIR.defaultBlockState(), var4, var5);
    }

    protected static void preventDropFromBottomPart(World var0, BlockPosition var1, IBlockData var2, EntityHuman var3) {
        BlockPosition var5;
        IBlockData var6;
        BlockPropertyDoubleBlockHalf var4 = var2.getValue(HALF);
        if (var4 == BlockPropertyDoubleBlockHalf.UPPER && (var6 = var0.getBlockState(var5 = var1.below())).is(var2.getBlock()) && var6.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER) {
            IBlockData var7 = var6.getFluidState().is(FluidTypes.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
            var0.setBlock(var5, var7, 35);
            var0.levelEvent(var3, 2001, var5, Block.getId(var6));
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(HALF);
    }

    @Override
    protected long getSeed(IBlockData var0, BlockPosition var1) {
        return MathHelper.getSeed(var1.getX(), var1.below(var0.getValue(HALF) == BlockPropertyDoubleBlockHalf.LOWER ? 0 : 1).getY(), var1.getZ());
    }
}

