/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTorch;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class BlockTorchWall
extends BlockTorch {
    public static final MapCodec<BlockTorchWall> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)PARTICLE_OPTIONS_FIELD.forGetter(var0 -> var0.flameParticle), BlockTorchWall.propertiesCodec()).apply((Applicative)var02, BlockTorchWall::new));
    public static final BlockStateEnum<EnumDirection> FACING = BlockFacingHorizontal.FACING;
    private static final Map<EnumDirection, VoxelShape> SHAPES = VoxelShapes.rotateHorizontal(Block.boxZ(5.0, 3.0, 13.0, 11.0, 16.0));

    public MapCodec<BlockTorchWall> codec() {
        return CODEC;
    }

    protected BlockTorchWall(ParticleType var0, BlockBase.Info var1) {
        super(var0, var1);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return BlockTorchWall.getShape(var0);
    }

    public static VoxelShape getShape(IBlockData var0) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return BlockTorchWall.canSurvive(var1, var2, var0.getValue(FACING));
    }

    public static boolean canSurvive(IWorldReader var0, BlockPosition var1, EnumDirection var2) {
        BlockPosition var3 = var1.relative(var2.getOpposite());
        IBlockData var4 = var0.getBlockState(var3);
        return var4.isFaceSturdy(var0, var3, var2);
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        EnumDirection[] var4;
        IBlockData var1 = this.defaultBlockState();
        World var2 = var0.getLevel();
        BlockPosition var3 = var0.getClickedPos();
        for (EnumDirection var8 : var4 = var0.getNearestLookingDirections()) {
            EnumDirection var9;
            if (!var8.getAxis().isHorizontal() || !(var1 = (IBlockData)var1.setValue(FACING, var9 = var8.getOpposite())).canSurvive(var2, var3)) continue;
            return var1;
        }
        return null;
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var4.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return var0;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        EnumDirection var4 = var0.getValue(FACING);
        double var5 = (double)var2.getX() + 0.5;
        double var7 = (double)var2.getY() + 0.7;
        double var9 = (double)var2.getZ() + 0.5;
        double var11 = 0.22;
        double var13 = 0.27;
        EnumDirection var15 = var4.getOpposite();
        var1.addParticle(Particles.SMOKE, var5 + 0.27 * (double)var15.getStepX(), var7 + 0.22, var9 + 0.27 * (double)var15.getStepZ(), 0.0, 0.0, 0.0);
        var1.addParticle(this.flameParticle, var5 + 0.27 * (double)var15.getStepX(), var7 + 0.22, var9 + 0.27 * (double)var15.getStepZ(), 0.0, 0.0, 0.0);
    }

    @Override
    protected IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING);
    }
}

