/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.vehicle.boat.AbstractBoat;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockIce;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class BlockWaterLily
extends VegetationBlock {
    public static final MapCodec<BlockWaterLily> CODEC = BlockWaterLily.simpleCodec(BlockWaterLily::new);
    private static final VoxelShape SHAPE = Block.column(14.0, 0.0, 1.5);

    public MapCodec<BlockWaterLily> codec() {
        return CODEC;
    }

    protected BlockWaterLily(BlockBase.Info var0) {
        super(var0);
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4, boolean var5) {
        super.entityInside(var0, var1, var2, var3, var4, var5);
        if (var1 instanceof WorldServer && var3 instanceof AbstractBoat) {
            var1.destroyBlock(new BlockPosition(var2), true, var3);
        }
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPE;
    }

    @Override
    protected boolean mayPlaceOn(IBlockData var0, IBlockAccess var1, BlockPosition var2) {
        Fluid var3 = var1.getFluidState(var2);
        Fluid var4 = var1.getFluidState(var2.above());
        return (var3.getType() == FluidTypes.WATER || var0.getBlock() instanceof BlockIce) && var4.getType() == FluidTypes.EMPTY;
    }
}

