/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.CalibratedSculkSensorBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jspecify.annotations.Nullable;

public class CalibratedSculkSensorBlock
extends SculkSensorBlock {
    public static final MapCodec<CalibratedSculkSensorBlock> CODEC = CalibratedSculkSensorBlock.simpleCodec(CalibratedSculkSensorBlock::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockProperties.HORIZONTAL_FACING;

    public MapCodec<CalibratedSculkSensorBlock> codec() {
        return CODEC;
    }

    public CalibratedSculkSensorBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)this.defaultBlockState().setValue(FACING, EnumDirection.NORTH));
    }

    @Override
    public @Nullable TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new CalibratedSculkSensorBlockEntity(var0, var1);
    }

    @Override
    public <T extends TileEntity> @Nullable BlockEntityTicker<T> getTicker(World var02, IBlockData var12, TileEntityTypes<T> var22) {
        if (!var02.isClientSide()) {
            return CalibratedSculkSensorBlock.createTickerHelper(var22, TileEntityTypes.CALIBRATED_SCULK_SENSOR, (var0, var1, var2, var3) -> VibrationSystem.c.tick(var0, var3.getVibrationData(), var3.getVibrationUser()));
        }
        return null;
    }

    @Override
    public @Nullable IBlockData getStateForPlacement(BlockActionContext var0) {
        return (IBlockData)super.getStateForPlacement(var0).setValue(FACING, var0.getHorizontalDirection());
    }

    @Override
    public int getSignal(IBlockData var0, IBlockAccess var1, BlockPosition var2, EnumDirection var3) {
        if (var3 != var0.getValue(FACING)) {
            return super.getSignal(var0, var1, var2, var3);
        }
        return 0;
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        super.createBlockStateDefinition(var0);
        var0.add(FACING);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public int getActiveTicks() {
        return 10;
    }
}

