/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class DoubleBlockFinder {
    public static <S extends TileEntity> Result<S> combineWithNeigbour(TileEntityTypes<S> var0, Function<IBlockData, BlockType> var1, Function<IBlockData, EnumDirection> var2, IBlockState<EnumDirection> var3, IBlockData var4, GeneratorAccess var5, BlockPosition var6, BiPredicate<GeneratorAccess, BlockPosition> var7) {
        BlockType var14;
        boolean var11;
        S var8 = var0.getBlockEntity(var5, var6);
        if (var8 == null) {
            return Combiner::acceptNone;
        }
        if (var7.test(var5, var6)) {
            return Combiner::acceptNone;
        }
        BlockType var9 = var1.apply(var4);
        boolean var10 = var9 == BlockType.SINGLE;
        boolean bl = var11 = var9 == BlockType.FIRST;
        if (var10) {
            return new Result.Single<S>(var8);
        }
        BlockPosition var12 = var6.relative(var2.apply(var4));
        IBlockData var13 = var5.getBlockState(var12);
        if (var13.is(var4.getBlock()) && (var14 = var1.apply(var13)) != BlockType.SINGLE && var9 != var14 && var13.getValue(var3) == var4.getValue(var3)) {
            if (var7.test(var5, var12)) {
                return Combiner::acceptNone;
            }
            S var15 = var0.getBlockEntity(var5, var12);
            if (var15 != null) {
                S var16 = var11 ? var8 : var15;
                S var17 = var11 ? var15 : var8;
                return new Result.Double<S>(var16, var17);
            }
        }
        return new Result.Single<S>(var8);
    }

    public static interface Result<S> {
        public <T> T apply(Combiner<? super S, T> var1);

        public static final class Single<S>
        implements Result<S> {
            private final S single;

            public Single(S var0) {
                this.single = var0;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> var0) {
                return var0.acceptSingle(this.single);
            }
        }

        public static final class Double<S>
        implements Result<S> {
            private final S first;
            private final S second;

            public Double(S var0, S var1) {
                this.first = var0;
                this.second = var1;
            }

            @Override
            public <T> T apply(Combiner<? super S, T> var0) {
                return var0.acceptDouble(this.first, this.second);
            }
        }
    }

    public static final class BlockType
    extends Enum<BlockType> {
        public static final /* enum */ BlockType SINGLE = new BlockType();
        public static final /* enum */ BlockType FIRST = new BlockType();
        public static final /* enum */ BlockType SECOND = new BlockType();
        private static final /* synthetic */ BlockType[] d;

        public static BlockType[] values() {
            return (BlockType[])d.clone();
        }

        public static BlockType valueOf(String var0) {
            return Enum.valueOf(BlockType.class, var0);
        }

        private static /* synthetic */ BlockType[] a() {
            return new BlockType[]{SINGLE, FIRST, SECOND};
        }

        static {
            d = BlockType.a();
        }
    }

    public static interface Combiner<S, T> {
        public T acceptDouble(S var1, S var2);

        public T acceptSingle(S var1);

        public T acceptNone();
    }
}

