/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.math.PointGroupO;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;

public final class EnumBlockRotation
extends Enum<EnumBlockRotation>
implements INamable {
    public static final /* enum */ EnumBlockRotation NONE = new EnumBlockRotation(0, "none", PointGroupO.IDENTITY);
    public static final /* enum */ EnumBlockRotation CLOCKWISE_90 = new EnumBlockRotation(1, "clockwise_90", PointGroupO.ROT_90_Y_NEG);
    public static final /* enum */ EnumBlockRotation CLOCKWISE_180 = new EnumBlockRotation(2, "180", PointGroupO.ROT_180_FACE_XZ);
    public static final /* enum */ EnumBlockRotation COUNTERCLOCKWISE_90 = new EnumBlockRotation(3, "counterclockwise_90", PointGroupO.ROT_90_Y_POS);
    public static final IntFunction<EnumBlockRotation> BY_ID;
    public static final Codec<EnumBlockRotation> CODEC;
    public static final StreamCodec<ByteBuf, EnumBlockRotation> STREAM_CODEC;
    @Deprecated
    public static final Codec<EnumBlockRotation> LEGACY_CODEC;
    private final int index;
    private final String id;
    private final PointGroupO rotation;
    private static final /* synthetic */ EnumBlockRotation[] l;

    public static EnumBlockRotation[] values() {
        return (EnumBlockRotation[])l.clone();
    }

    public static EnumBlockRotation valueOf(String var0) {
        return Enum.valueOf(EnumBlockRotation.class, var0);
    }

    private EnumBlockRotation(int var2, String var3, PointGroupO var4) {
        this.index = var2;
        this.id = var3;
        this.rotation = var4;
    }

    public EnumBlockRotation getRotated(EnumBlockRotation var0) {
        return switch (var0.ordinal()) {
            case 2 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield CLOCKWISE_180;
                    }
                    case 1: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 2: {
                        yield NONE;
                    }
                    case 3: 
                }
                yield CLOCKWISE_90;
            }
            case 3 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 1: {
                        yield NONE;
                    }
                    case 2: {
                        yield CLOCKWISE_90;
                    }
                    case 3: 
                }
                yield CLOCKWISE_180;
            }
            case 1 -> {
                switch (this.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        yield CLOCKWISE_90;
                    }
                    case 1: {
                        yield CLOCKWISE_180;
                    }
                    case 2: {
                        yield COUNTERCLOCKWISE_90;
                    }
                    case 3: 
                }
                yield NONE;
            }
            default -> this;
        };
    }

    public PointGroupO rotation() {
        return this.rotation;
    }

    public EnumDirection rotate(EnumDirection var0) {
        if (var0.getAxis() == EnumDirection.EnumAxis.Y) {
            return var0;
        }
        return switch (this.ordinal()) {
            case 2 -> var0.getOpposite();
            case 3 -> var0.getCounterClockWise();
            case 1 -> var0.getClockWise();
            default -> var0;
        };
    }

    public int rotate(int var0, int var1) {
        return switch (this.ordinal()) {
            case 2 -> (var0 + var1 / 2) % var1;
            case 3 -> (var0 + var1 * 3 / 4) % var1;
            case 1 -> (var0 + var1 / 4) % var1;
            default -> var0;
        };
    }

    public static EnumBlockRotation getRandom(RandomSource var0) {
        return SystemUtils.getRandom(EnumBlockRotation.values(), var0);
    }

    public static List<EnumBlockRotation> getShuffled(RandomSource var0) {
        return SystemUtils.shuffledCopy(EnumBlockRotation.values(), var0);
    }

    @Override
    public String getSerializedName() {
        return this.id;
    }

    private int getIndex() {
        return this.index;
    }

    private static /* synthetic */ EnumBlockRotation[] d() {
        return new EnumBlockRotation[]{NONE, CLOCKWISE_90, CLOCKWISE_180, COUNTERCLOCKWISE_90};
    }

    static {
        l = EnumBlockRotation.d();
        BY_ID = ByIdMap.continuous(EnumBlockRotation::getIndex, EnumBlockRotation.values(), ByIdMap.a.WRAP);
        CODEC = INamable.fromEnum(EnumBlockRotation::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, EnumBlockRotation::getIndex);
        LEGACY_CODEC = ExtraCodecs.legacyEnum(EnumBlockRotation::valueOf);
    }
}

