/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;

public class FireflyBushBlock
extends VegetationBlock
implements IBlockFragilePlantElement {
    private static final double FIREFLY_CHANCE_PER_TICK = 0.7;
    private static final double FIREFLY_HORIZONTAL_RANGE = 10.0;
    private static final double FIREFLY_VERTICAL_RANGE = 5.0;
    private static final int FIREFLY_SPAWN_MAX_BRIGHTNESS_LEVEL = 13;
    private static final int FIREFLY_AMBIENT_SOUND_CHANCE_ONE_IN = 30;
    public static final MapCodec<FireflyBushBlock> CODEC = FireflyBushBlock.simpleCodec(FireflyBushBlock::new);

    public FireflyBushBlock(BlockBase.Info var0) {
        super(var0);
    }

    protected MapCodec<? extends FireflyBushBlock> codec() {
        return CODEC;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        if (var3.nextInt(30) == 0 && var1.environmentAttributes().getValue(EnvironmentAttributes.FIREFLY_BUSH_SOUNDS, var2).booleanValue() && var1.getHeight(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var2) <= var2.getY()) {
            var1.playLocalSound(var2, SoundEffects.FIREFLY_BUSH_IDLE, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        if (var1.getMaxLocalRawBrightness(var2) <= 13 && var3.nextDouble() <= 0.7) {
            double var4 = (double)var2.getX() + var3.nextDouble() * 10.0 - 5.0;
            double var6 = (double)var2.getY() + var3.nextDouble() * 5.0;
            double var8 = (double)var2.getZ() + var3.nextDouble() * 10.0 - 5.0;
            var1.addParticle(Particles.FIREFLY, var4, var6, var8, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return IBlockFragilePlantElement.hasSpreadableNeighbourPos(var0, var1, var2);
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var12, BlockPosition var2, IBlockData var3) {
        IBlockFragilePlantElement.findSpreadableNeighbourPos(var0, var2, var3).ifPresent(var1 -> var0.setBlockAndUpdate((BlockPosition)var1, this.defaultBlockState()));
    }
}

