/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.SegmentableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class FlowerBedBlock
extends VegetationBlock
implements IBlockFragilePlantElement,
SegmentableBlock {
    public static final MapCodec<FlowerBedBlock> CODEC = FlowerBedBlock.simpleCodec(FlowerBedBlock::new);
    public static final BlockStateEnum<EnumDirection> FACING = BlockProperties.HORIZONTAL_FACING;
    public static final BlockStateInteger AMOUNT = BlockProperties.FLOWER_AMOUNT;
    private final Function<IBlockData, VoxelShape> shapes;

    public MapCodec<FlowerBedBlock> codec() {
        return CODEC;
    }

    protected FlowerBedBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(AMOUNT, 1));
        this.shapes = this.makeShapes();
    }

    private Function<IBlockData, VoxelShape> makeShapes() {
        return this.getShapeForEachState(this.getShapeCalculator(FACING, AMOUNT));
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public boolean canBeReplaced(IBlockData var0, BlockActionContext var1) {
        if (this.canBeReplaced(var0, var1, AMOUNT)) {
            return true;
        }
        return super.canBeReplaced(var0, var1);
    }

    @Override
    public VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return this.shapes.apply(var0);
    }

    @Override
    public double getShapeHeight() {
        return 3.0;
    }

    @Override
    public BlockStateInteger getSegmentAmountProperty() {
        return AMOUNT;
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        return this.getStateForPlacement(var0, this, AMOUNT, FACING);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, AMOUNT);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        int var4 = var3.getValue(AMOUNT);
        if (var4 < 4) {
            var0.setBlock(var2, (IBlockData)var3.setValue(AMOUNT, var4 + 1), 2);
        } else {
            FlowerBedBlock.popResource((World)var0, var2, new ItemStack(this));
        }
    }
}

