/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;

public class HangingMossBlock
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<HangingMossBlock> CODEC = HangingMossBlock.simpleCodec(HangingMossBlock::new);
    private static final VoxelShape SHAPE_BASE = Block.column(14.0, 0.0, 16.0);
    private static final VoxelShape SHAPE_TIP = Block.column(14.0, 2.0, 16.0);
    public static final BlockStateBoolean TIP = BlockProperties.TIP;

    public MapCodec<HangingMossBlock> codec() {
        return CODEC;
    }

    public HangingMossBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(TIP, true));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return var0.getValue(TIP) != false ? SHAPE_TIP : SHAPE_BASE;
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        IBlockData var4;
        if (var3.nextInt(500) == 0 && ((var4 = var1.getBlockState(var2.above())).is(TagsBlock.PALE_OAK_LOGS) || var4.is(Blocks.PALE_OAK_LEAVES))) {
            var1.playLocalSound(var2.getX(), var2.getY(), var2.getZ(), SoundEffects.PALE_HANGING_MOSS_IDLE, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected boolean propagatesSkylightDown(IBlockData var0) {
        return true;
    }

    @Override
    protected boolean canSurvive(IBlockData var0, IWorldReader var1, BlockPosition var2) {
        return this.canStayAtPosition(var1, var2);
    }

    private boolean canStayAtPosition(IBlockAccess var0, BlockPosition var1) {
        IBlockData var3;
        BlockPosition var2 = var1.relative(EnumDirection.UP);
        return MultifaceBlock.canAttachTo(var0, EnumDirection.UP, var2, var3 = var0.getBlockState(var2)) || var3.is(Blocks.PALE_HANGING_MOSS);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (!this.canStayAtPosition(var1, var3)) {
            var2.scheduleTick(var3, this, 1);
        }
        return (IBlockData)var0.setValue(TIP, !var1.getBlockState(var3.below()).is(this));
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!this.canStayAtPosition(var1, var2)) {
            var1.destroyBlock(var2, true);
        }
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(TIP);
    }

    @Override
    public boolean isValidBonemealTarget(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return this.canGrowInto(var0.getBlockState(this.getTip(var0, var1).below()));
    }

    private boolean canGrowInto(IBlockData var0) {
        return var0.isAir();
    }

    public BlockPosition getTip(IBlockAccess var0, BlockPosition var1) {
        IBlockData var3;
        BlockPosition.MutableBlockPosition var2 = var1.mutable();
        do {
            var2.move(EnumDirection.DOWN);
        } while ((var3 = var0.getBlockState(var2)).is(this));
        return ((BlockPosition)var2.relative(EnumDirection.UP)).immutable();
    }

    @Override
    public boolean isBonemealSuccess(World var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        return true;
    }

    @Override
    public void performBonemeal(WorldServer var0, RandomSource var1, BlockPosition var2, IBlockData var3) {
        BlockPosition var4 = this.getTip(var0, var2).below();
        if (!this.canGrowInto(var0.getBlockState(var4))) {
            return;
        }
        var0.setBlockAndUpdate(var4, (IBlockData)var3.setValue(TIP, true));
    }
}

