/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.BlockStateInteger;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public interface SegmentableBlock {
    public static final int MIN_SEGMENT = 1;
    public static final int MAX_SEGMENT = 4;
    public static final BlockStateInteger AMOUNT = BlockProperties.SEGMENT_AMOUNT;

    default public Function<IBlockData, VoxelShape> getShapeCalculator(BlockStateEnum<EnumDirection> var0, BlockStateInteger var1) {
        Map<EnumDirection, VoxelShape> var2 = VoxelShapes.rotateHorizontal(Block.box(0.0, 0.0, 0.0, 8.0, this.getShapeHeight(), 8.0));
        return var3 -> {
            VoxelShape var4 = VoxelShapes.empty();
            EnumDirection var5 = (EnumDirection)var3.getValue(var0);
            int var6 = var3.getValue(var1);
            for (int var7 = 0; var7 < var6; ++var7) {
                var4 = VoxelShapes.or(var4, (VoxelShape)var2.get(var5));
                var5 = var5.getCounterClockWise();
            }
            return var4.singleEncompassing();
        };
    }

    default public BlockStateInteger getSegmentAmountProperty() {
        return AMOUNT;
    }

    default public double getShapeHeight() {
        return 1.0;
    }

    default public boolean canBeReplaced(IBlockData var0, BlockActionContext var1, BlockStateInteger var2) {
        return !var1.isSecondaryUseActive() && var1.getItemInHand().is(var0.getBlock().asItem()) && var0.getValue(var2) < 4;
    }

    default public IBlockData getStateForPlacement(BlockActionContext var0, Block var1, BlockStateInteger var2, BlockStateEnum<EnumDirection> var3) {
        IBlockData var4 = var0.getLevel().getBlockState(var0.getClickedPos());
        if (var4.is(var1)) {
            return (IBlockData)var4.setValue(var2, Math.min(4, var4.getValue(var2) + 1));
        }
        return (IBlockData)var1.defaultBlockState().setValue(var3, var0.getHorizontalDirection().getOpposite());
    }
}

