/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.SideChainPartBlock;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.SideChainPart;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.jspecify.annotations.Nullable;

public class ShelfBlock
extends BlockTileEntity
implements SelectableSlotContainer,
SideChainPartBlock,
IBlockWaterlogged {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.simpleCodec(ShelfBlock::new);
    public static final BlockStateBoolean POWERED = BlockProperties.POWERED;
    public static final BlockStateEnum<EnumDirection> FACING = BlockProperties.HORIZONTAL_FACING;
    public static final BlockStateEnum<SideChainPart> SIDE_CHAIN_PART = BlockProperties.SIDE_CHAIN_PART;
    public static final BlockStateBoolean WATERLOGGED = BlockProperties.WATERLOGGED;
    private static final Map<EnumDirection, VoxelShape> SHAPES = VoxelShapes.rotateHorizontal(VoxelShapes.or(Block.box(0.0, 12.0, 11.0, 16.0, 16.0, 13.0), Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), Block.box(0.0, 0.0, 11.0, 16.0, 4.0, 13.0)));

    public MapCodec<ShelfBlock> codec() {
        return CODEC;
    }

    public ShelfBlock(BlockBase.Info var0) {
        super(var0);
        this.registerDefaultState((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.stateDefinition.any()).setValue(FACING, EnumDirection.NORTH)).setValue(POWERED, false)).setValue(SIDE_CHAIN_PART, SideChainPart.UNCONNECTED)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(IBlockData var0, IBlockAccess var1, BlockPosition var2, VoxelShapeCollision var3) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    protected boolean useShapeForLightOcclusion(IBlockData var0) {
        return true;
    }

    @Override
    protected boolean isPathfindable(IBlockData var0, PathMode var1) {
        return var1 == PathMode.WATER && var0.getFluidState().is(TagsFluid.WATER);
    }

    @Override
    public @Nullable TileEntity newBlockEntity(BlockPosition var0, IBlockData var1) {
        return new ShelfBlockEntity(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(BlockStateList.a<Block, IBlockData> var0) {
        var0.add(FACING, POWERED, SIDE_CHAIN_PART, WATERLOGGED);
    }

    @Override
    protected void affectNeighborsAfterRemoval(IBlockData var0, WorldServer var1, BlockPosition var2, boolean var3) {
        InventoryUtils.updateNeighboursAfterDestroy(var0, var1, var2);
        this.updateNeighborsAfterPoweringDown(var1, var2, var0);
    }

    @Override
    protected void neighborChanged(IBlockData var0, World var1, BlockPosition var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide()) {
            return;
        }
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var0.getValue(POWERED) != var6) {
            IBlockData var7 = (IBlockData)var0.setValue(POWERED, var6);
            if (!var6) {
                var7 = (IBlockData)var7.setValue(SIDE_CHAIN_PART, SideChainPart.UNCONNECTED);
            }
            var1.setBlock(var2, var7, 3);
            this.playSound(var1, var2, var6 ? SoundEffects.SHELF_ACTIVATE : SoundEffects.SHELF_DEACTIVATE);
            var1.gameEvent(var6 ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, var2, GameEvent.a.of(var7));
        }
    }

    @Override
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (IBlockData)((IBlockData)((IBlockData)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(POWERED, var0.getLevel().hasNeighborSignal(var0.getClickedPos()))).setValue(WATERLOGGED, var1.getType() == FluidTypes.WATER);
    }

    @Override
    public IBlockData rotate(IBlockData var0, EnumBlockRotation var1) {
        return (IBlockData)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public IBlockData mirror(IBlockData var0, EnumBlockMirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public int getRows() {
        return 1;
    }

    @Override
    public int getColumns() {
        return 3;
    }

    @Override
    protected EnumInteractionResult useItemOn(ItemStack var0, IBlockData var1, World var2, BlockPosition var3, EntityHuman var4, EnumHand var5, MovingObjectPositionBlock var6) {
        ShelfBlockEntity var7;
        block13: {
            block12: {
                TileEntity tileEntity = var2.getBlockEntity(var3);
                if (!(tileEntity instanceof ShelfBlockEntity)) break block12;
                var7 = (ShelfBlockEntity)tileEntity;
                if (!var5.equals((Object)EnumHand.OFF_HAND)) break block13;
            }
            return EnumInteractionResult.PASS;
        }
        OptionalInt var8 = this.getHitSlot(var6, var1.getValue(FACING));
        if (var8.isEmpty()) {
            return EnumInteractionResult.PASS;
        }
        PlayerInventory var9 = var4.getInventory();
        if (var2.isClientSide()) {
            return var9.getSelectedItem().isEmpty() ? EnumInteractionResult.PASS : EnumInteractionResult.SUCCESS;
        }
        if (!var1.getValue(POWERED).booleanValue()) {
            boolean var10 = ShelfBlock.swapSingleItem(var0, var4, var7, var8.getAsInt(), var9);
            if (var10) {
                this.playSound(var2, var3, var0.isEmpty() ? SoundEffects.SHELF_TAKE_ITEM : SoundEffects.SHELF_SINGLE_SWAP);
            } else if (!var0.isEmpty()) {
                this.playSound(var2, var3, SoundEffects.SHELF_PLACE_ITEM);
            } else {
                return EnumInteractionResult.PASS;
            }
            return EnumInteractionResult.SUCCESS.heldItemTransformedTo(var0);
        }
        ItemStack var10 = var9.getSelectedItem();
        boolean var11 = this.swapHotbar(var2, var3, var9);
        if (!var11) {
            return EnumInteractionResult.CONSUME;
        }
        this.playSound(var2, var3, SoundEffects.SHELF_MULTI_SWAP);
        if (var10 == var9.getSelectedItem()) {
            return EnumInteractionResult.SUCCESS;
        }
        return EnumInteractionResult.SUCCESS.heldItemTransformedTo(var9.getSelectedItem());
    }

    private static boolean swapSingleItem(ItemStack var0, EntityHuman var1, ShelfBlockEntity var2, int var3, PlayerInventory var4) {
        ItemStack var5 = var2.swapItemNoUpdate(var3, var0);
        ItemStack var6 = var1.hasInfiniteMaterials() && var5.isEmpty() ? var0.copy() : var5;
        var4.setItem(var4.getSelectedSlot(), var6);
        var4.setChanged();
        var2.setChanged((Holder.c<GameEvent>)(var6.has(DataComponents.USE_EFFECTS) && !var6.get(DataComponents.USE_EFFECTS).interactVibrations() ? null : GameEvent.ITEM_INTERACT_FINISH));
        return !var5.isEmpty();
    }

    private boolean swapHotbar(World var0, BlockPosition var1, PlayerInventory var2) {
        List<BlockPosition> var3 = this.getAllBlocksConnectedTo(var0, var1);
        if (var3.isEmpty()) {
            return false;
        }
        boolean var4 = false;
        for (int var5 = 0; var5 < var3.size(); ++var5) {
            ShelfBlockEntity var6 = (ShelfBlockEntity)var0.getBlockEntity(var3.get(var5));
            if (var6 == null) continue;
            for (int var7 = 0; var7 < var6.getContainerSize(); ++var7) {
                int var8 = 9 - (var3.size() - var5) * var6.getContainerSize() + var7;
                if (var8 < 0 || var8 > var2.getContainerSize()) continue;
                ItemStack var9 = var2.removeItemNoUpdate(var8);
                ItemStack var10 = var6.swapItemNoUpdate(var7, var9);
                if (var9.isEmpty() && var10.isEmpty()) continue;
                var2.setItem(var8, var10);
                var4 = true;
            }
            var2.setChanged();
            var6.setChanged(GameEvent.ENTITY_INTERACT);
        }
        return var4;
    }

    @Override
    public SideChainPart getSideChainPart(IBlockData var0) {
        return var0.getValue(SIDE_CHAIN_PART);
    }

    @Override
    public IBlockData setSideChainPart(IBlockData var0, SideChainPart var1) {
        return (IBlockData)var0.setValue(SIDE_CHAIN_PART, var1);
    }

    @Override
    public EnumDirection getFacing(IBlockData var0) {
        return var0.getValue(FACING);
    }

    @Override
    public boolean isConnectable(IBlockData var0) {
        return var0.is(TagsBlock.WOODEN_SHELVES) && var0.hasProperty(POWERED) && var0.getValue(POWERED) != false;
    }

    @Override
    public int getMaxChainLength() {
        return 3;
    }

    @Override
    protected void onPlace(IBlockData var0, World var1, BlockPosition var2, IBlockData var3, boolean var4) {
        if (var0.getValue(POWERED).booleanValue()) {
            this.updateSelfAndNeighborsOnPoweringUp(var1, var2, var0, var3);
        } else {
            this.updateNeighborsAfterPoweringDown(var1, var2, var0);
        }
    }

    private void playSound(GeneratorAccess var0, BlockPosition var1, SoundEffect var2) {
        var0.playSound(null, var1, var2, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return FluidTypes.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected IBlockData updateShape(IBlockData var0, IWorldReader var1, ScheduledTickAccess var2, BlockPosition var3, EnumDirection var4, BlockPosition var5, IBlockData var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, FluidTypes.WATER, FluidTypes.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean hasAnalogOutputSignal(IBlockData var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(IBlockData var0, World var1, BlockPosition var2, EnumDirection var3) {
        if (var1.isClientSide()) {
            return 0;
        }
        if (var3 != var0.getValue(FACING).getOpposite()) {
            return 0;
        }
        TileEntity tileEntity = var1.getBlockEntity(var2);
        if (tileEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity var4 = (ShelfBlockEntity)tileEntity;
            int var5 = var4.getItem(0).isEmpty() ? 0 : 1;
            int var6 = var4.getItem(1).isEmpty() ? 0 : 1;
            int var7 = var4.getItem(2).isEmpty() ? 0 : 1;
            return var5 | var6 << 1 | var7 << 2;
        }
        return 0;
    }
}

