/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BlockChest;
import net.minecraft.world.level.block.CopperChestBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityChest;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyChestType;

public class WeatheringCopperChestBlock
extends CopperChestBlock
implements WeatheringCopper {
    public static final MapCodec<WeatheringCopperChestBlock> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)WeatheringCopper.a.CODEC.fieldOf("weathering_state").forGetter(CopperChestBlock::getState), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("open_sound").forGetter(BlockChest::getOpenChestSound), (App)BuiltInRegistries.SOUND_EVENT.byNameCodec().fieldOf("close_sound").forGetter(BlockChest::getCloseChestSound), WeatheringCopperChestBlock.propertiesCodec()).apply((Applicative)var0, WeatheringCopperChestBlock::new));

    @Override
    public MapCodec<WeatheringCopperChestBlock> codec() {
        return CODEC;
    }

    public WeatheringCopperChestBlock(WeatheringCopper.a var0, SoundEffect var1, SoundEffect var2, BlockBase.Info var3) {
        super(var0, var1, var2, var3);
    }

    @Override
    protected boolean isRandomlyTicking(IBlockData var0) {
        return WeatheringCopper.getNext(var0.getBlock()).isPresent();
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        TileEntityChest var4;
        TileEntity tileEntity;
        if (!var0.getValue(BlockChest.TYPE).equals(BlockPropertyChestType.RIGHT) && (tileEntity = var1.getBlockEntity(var2)) instanceof TileEntityChest && (var4 = (TileEntityChest)tileEntity).getEntitiesWithContainerOpen().isEmpty()) {
            this.changeOverTime(var0, var1, var2, var3);
        }
    }

    @Override
    public WeatheringCopper.a getAge() {
        return this.getState();
    }

    @Override
    public boolean isWaxed() {
        return false;
    }

    @Override
    public /* synthetic */ Enum getAge() {
        return this.getAge();
    }
}

