/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class SculkSensorBlockEntity
extends TileEntity
implements GameEventListener.b<VibrationSystem.b>,
VibrationSystem {
    private static final int DEFAULT_LAST_VIBRATION_FREQUENCY = 0;
    private VibrationSystem.a vibrationData;
    private final VibrationSystem.b vibrationListener;
    private final VibrationSystem.d vibrationUser = this.createVibrationUser();
    public int lastVibrationFrequency = 0;

    protected SculkSensorBlockEntity(TileEntityTypes<?> var0, BlockPosition var1, IBlockData var2) {
        super(var0, var1, var2);
        this.vibrationData = new VibrationSystem.a();
        this.vibrationListener = new VibrationSystem.b(this);
    }

    public SculkSensorBlockEntity(BlockPosition var0, IBlockData var1) {
        this(TileEntityTypes.SCULK_SENSOR, var0, var1);
    }

    public VibrationSystem.d createVibrationUser() {
        return new a(this.getBlockPos());
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.lastVibrationFrequency = var0.getIntOr("last_vibration_frequency", 0);
        this.vibrationData = var0.read("listener", VibrationSystem.a.CODEC).orElseGet(VibrationSystem.a::new);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.putInt("last_vibration_frequency", this.lastVibrationFrequency);
        var0.store("listener", VibrationSystem.a.CODEC, this.vibrationData);
    }

    @Override
    public VibrationSystem.a getVibrationData() {
        return this.vibrationData;
    }

    @Override
    public VibrationSystem.d getVibrationUser() {
        return this.vibrationUser;
    }

    public int getLastVibrationFrequency() {
        return this.lastVibrationFrequency;
    }

    public void setLastVibrationFrequency(int var0) {
        this.lastVibrationFrequency = var0;
    }

    @Override
    public VibrationSystem.b getListener() {
        return this.vibrationListener;
    }

    @Override
    public /* synthetic */ GameEventListener getListener() {
        return this.getListener();
    }

    protected class a
    implements VibrationSystem.d {
        public static final int LISTENER_RANGE = 8;
        protected final BlockPosition blockPos;
        private final PositionSource positionSource;

        public a(BlockPosition var1) {
            this.blockPos = var1;
            this.positionSource = new BlockPositionSource(var1);
        }

        @Override
        public int getListenerRadius() {
            return 8;
        }

        @Override
        public PositionSource getPositionSource() {
            return this.positionSource;
        }

        @Override
        public boolean canTriggerAvoidVibration() {
            return true;
        }

        @Override
        public boolean canReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, @Nullable GameEvent.a var3) {
            if (var1.equals(this.blockPos) && (var2.is(GameEvent.BLOCK_DESTROY) || var2.is(GameEvent.BLOCK_PLACE))) {
                return false;
            }
            if (VibrationSystem.getGameEventFrequency(var2) == 0) {
                return false;
            }
            return SculkSensorBlock.canActivate(SculkSensorBlockEntity.this.getBlockState());
        }

        @Override
        public void onReceiveVibration(WorldServer var0, BlockPosition var1, Holder<GameEvent> var2, @Nullable Entity var3, @Nullable Entity var4, float var5) {
            IBlockData var6 = SculkSensorBlockEntity.this.getBlockState();
            if (SculkSensorBlock.canActivate(var6)) {
                int var7 = VibrationSystem.getGameEventFrequency(var2);
                SculkSensorBlockEntity.this.setLastVibrationFrequency(var7);
                int var8 = VibrationSystem.getRedstoneStrengthForDistance(var5, this.getListenerRadius());
                Block block = var6.getBlock();
                if (block instanceof SculkSensorBlock) {
                    SculkSensorBlock var9 = (SculkSensorBlock)block;
                    var9.activate(var3, var0, this.blockPos, var6, var8, var7);
                }
            }
        }

        @Override
        public void onDataChanged() {
            SculkSensorBlockEntity.this.setChanged();
        }

        @Override
        public boolean requiresAdjacentChunksToBeTicking() {
            return true;
        }
    }
}

