/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TestBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class TestBlockEntity
extends TileEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String DEFAULT_MESSAGE = "";
    private static final boolean DEFAULT_POWERED = false;
    private TestBlockMode mode;
    private String message = "";
    private boolean powered = false;
    private boolean triggered;

    public TestBlockEntity(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.TEST_BLOCK, var0, var1);
        this.mode = var1.getValue(TestBlock.MODE);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        var0.store("mode", TestBlockMode.CODEC, this.mode);
        var0.putString("message", this.message);
        var0.putBoolean("powered", this.powered);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        this.mode = var0.read("mode", TestBlockMode.CODEC).orElse(TestBlockMode.FAIL);
        this.message = var0.getStringOr("message", DEFAULT_MESSAGE);
        this.powered = var0.getBooleanOr("powered", false);
    }

    private void updateBlockState() {
        if (this.level == null) {
            return;
        }
        BlockPosition var0 = this.getBlockPos();
        IBlockData var1 = this.level.getBlockState(var0);
        if (var1.is(Blocks.TEST_BLOCK)) {
            this.level.setBlock(var0, (IBlockData)var1.setValue(TestBlock.MODE, this.mode), 2);
        }
    }

    public @Nullable PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean var0) {
        this.powered = var0;
    }

    public TestBlockMode getMode() {
        return this.mode;
    }

    public void setMode(TestBlockMode var0) {
        this.mode = var0;
        this.updateBlockState();
    }

    private Block getBlockType() {
        return this.getBlockState().getBlock();
    }

    public void reset() {
        this.triggered = false;
        if (this.mode == TestBlockMode.START && this.level != null) {
            this.setPowered(false);
            this.level.updateNeighborsAt(this.getBlockPos(), this.getBlockType());
        }
    }

    public void trigger() {
        if (this.mode == TestBlockMode.START && this.level != null) {
            this.setPowered(true);
            BlockPosition var0 = this.getBlockPos();
            this.level.updateNeighborsAt(var0, this.getBlockType());
            this.level.getBlockTicks().willTickThisTick(var0, this.getBlockType());
            this.log();
            return;
        }
        if (this.mode == TestBlockMode.LOG) {
            this.log();
        }
        this.triggered = true;
    }

    public void log() {
        if (!this.message.isBlank()) {
            LOGGER.info("Test {} (at {}): {}", new Object[]{this.mode.getSerializedName(), this.getBlockPos(), this.message});
        }
    }

    public boolean hasTriggered() {
        return this.triggered;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String var0) {
        this.message = var0;
    }

    public /* synthetic */ @Nullable Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }
}

