/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SystemUtils;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.jspecify.annotations.Nullable;

public class TileEntityStructure
extends TileEntity
implements BoundingBoxRenderable {
    private static final int SCAN_CORNER_BLOCKS_RANGE = 5;
    public static final int MAX_OFFSET_PER_AXIS = 48;
    public static final int MAX_SIZE_PER_AXIS = 48;
    public static final String AUTHOR_TAG = "author";
    private static final String DEFAULT_AUTHOR = "";
    private static final String DEFAULT_METADATA = "";
    private static final BlockPosition DEFAULT_POS = new BlockPosition(0, 1, 0);
    private static final BaseBlockPosition DEFAULT_SIZE = BaseBlockPosition.ZERO;
    private static final EnumBlockRotation DEFAULT_ROTATION = EnumBlockRotation.NONE;
    private static final EnumBlockMirror DEFAULT_MIRROR = EnumBlockMirror.NONE;
    private static final boolean DEFAULT_IGNORE_ENTITIES = true;
    private static final boolean DEFAULT_STRICT = false;
    private static final boolean DEFAULT_POWERED = false;
    private static final boolean DEFAULT_SHOW_AIR = false;
    private static final boolean DEFAULT_SHOW_BOUNDING_BOX = true;
    private static final float DEFAULT_INTEGRITY = 1.0f;
    private static final long DEFAULT_SEED = 0L;
    private @Nullable MinecraftKey structureName;
    public String author = "";
    public String metaData = "";
    public BlockPosition structurePos = DEFAULT_POS;
    public BaseBlockPosition structureSize = DEFAULT_SIZE;
    public EnumBlockMirror mirror = EnumBlockMirror.NONE;
    public EnumBlockRotation rotation = EnumBlockRotation.NONE;
    public BlockPropertyStructureMode mode;
    public boolean ignoreEntities = true;
    private boolean strict = false;
    private boolean powered = false;
    public boolean showAir = false;
    public boolean showBoundingBox = true;
    public float integrity = 1.0f;
    public long seed = 0L;

    public TileEntityStructure(BlockPosition var0, IBlockData var1) {
        super(TileEntityTypes.STRUCTURE_BLOCK, var0, var1);
        this.mode = var1.getValue(BlockStructure.MODE);
    }

    @Override
    protected void saveAdditional(ValueOutput var0) {
        super.saveAdditional(var0);
        var0.putString("name", this.getStructureName());
        var0.putString(AUTHOR_TAG, this.author);
        var0.putString("metadata", this.metaData);
        var0.putInt("posX", this.structurePos.getX());
        var0.putInt("posY", this.structurePos.getY());
        var0.putInt("posZ", this.structurePos.getZ());
        var0.putInt("sizeX", this.structureSize.getX());
        var0.putInt("sizeY", this.structureSize.getY());
        var0.putInt("sizeZ", this.structureSize.getZ());
        var0.store("rotation", EnumBlockRotation.LEGACY_CODEC, this.rotation);
        var0.store("mirror", EnumBlockMirror.LEGACY_CODEC, this.mirror);
        var0.store("mode", BlockPropertyStructureMode.LEGACY_CODEC, this.mode);
        var0.putBoolean("ignoreEntities", this.ignoreEntities);
        var0.putBoolean("strict", this.strict);
        var0.putBoolean("powered", this.powered);
        var0.putBoolean("showair", this.showAir);
        var0.putBoolean("showboundingbox", this.showBoundingBox);
        var0.putFloat("integrity", this.integrity);
        var0.putLong("seed", this.seed);
    }

    @Override
    protected void loadAdditional(ValueInput var0) {
        super.loadAdditional(var0);
        this.setStructureName(var0.getStringOr("name", ""));
        this.author = var0.getStringOr(AUTHOR_TAG, "");
        this.metaData = var0.getStringOr("metadata", "");
        int var1 = MathHelper.clamp(var0.getIntOr("posX", DEFAULT_POS.getX()), -48, 48);
        int var2 = MathHelper.clamp(var0.getIntOr("posY", DEFAULT_POS.getY()), -48, 48);
        int var3 = MathHelper.clamp(var0.getIntOr("posZ", DEFAULT_POS.getZ()), -48, 48);
        this.structurePos = new BlockPosition(var1, var2, var3);
        int var4 = MathHelper.clamp(var0.getIntOr("sizeX", DEFAULT_SIZE.getX()), 0, 48);
        int var5 = MathHelper.clamp(var0.getIntOr("sizeY", DEFAULT_SIZE.getY()), 0, 48);
        int var6 = MathHelper.clamp(var0.getIntOr("sizeZ", DEFAULT_SIZE.getZ()), 0, 48);
        this.structureSize = new BaseBlockPosition(var4, var5, var6);
        this.rotation = var0.read("rotation", EnumBlockRotation.LEGACY_CODEC).orElse(DEFAULT_ROTATION);
        this.mirror = var0.read("mirror", EnumBlockMirror.LEGACY_CODEC).orElse(DEFAULT_MIRROR);
        this.mode = var0.read("mode", BlockPropertyStructureMode.LEGACY_CODEC).orElse(BlockPropertyStructureMode.DATA);
        this.ignoreEntities = var0.getBooleanOr("ignoreEntities", true);
        this.strict = var0.getBooleanOr("strict", false);
        this.powered = var0.getBooleanOr("powered", false);
        this.showAir = var0.getBooleanOr("showair", false);
        this.showBoundingBox = var0.getBooleanOr("showboundingbox", true);
        this.integrity = var0.getFloatOr("integrity", 1.0f);
        this.seed = var0.getLongOr("seed", 0L);
        this.updateBlockState();
    }

    private void updateBlockState() {
        if (this.level == null) {
            return;
        }
        BlockPosition var0 = this.getBlockPos();
        IBlockData var1 = this.level.getBlockState(var0);
        if (var1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(var0, (IBlockData)var1.setValue(BlockStructure.MODE, this.mode), 2);
        }
    }

    public PacketPlayOutTileEntityData getUpdatePacket() {
        return PacketPlayOutTileEntityData.create(this);
    }

    @Override
    public NBTTagCompound getUpdateTag(HolderLookup.a var0) {
        return this.saveCustomOnly(var0);
    }

    public boolean usedBy(EntityHuman var0) {
        if (!var0.canUseGameMasterBlocks()) {
            return false;
        }
        if (var0.level().isClientSide()) {
            var0.openStructureBlock(this);
        }
        return true;
    }

    public String getStructureName() {
        return this.structureName == null ? "" : this.structureName.toString();
    }

    public boolean hasStructureName() {
        return this.structureName != null;
    }

    public void setStructureName(@Nullable String var0) {
        this.setStructureName(UtilColor.isNullOrEmpty(var0) ? null : MinecraftKey.tryParse(var0));
    }

    public void setStructureName(@Nullable MinecraftKey var0) {
        this.structureName = var0;
    }

    public void createdBy(EntityLiving var0) {
        this.author = var0.getPlainTextName();
    }

    public BlockPosition getStructurePos() {
        return this.structurePos;
    }

    public void setStructurePos(BlockPosition var0) {
        this.structurePos = var0;
    }

    public BaseBlockPosition getStructureSize() {
        return this.structureSize;
    }

    public void setStructureSize(BaseBlockPosition var0) {
        this.structureSize = var0;
    }

    public EnumBlockMirror getMirror() {
        return this.mirror;
    }

    public void setMirror(EnumBlockMirror var0) {
        this.mirror = var0;
    }

    public EnumBlockRotation getRotation() {
        return this.rotation;
    }

    public void setRotation(EnumBlockRotation var0) {
        this.rotation = var0;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public void setMetaData(String var0) {
        this.metaData = var0;
    }

    public BlockPropertyStructureMode getMode() {
        return this.mode;
    }

    public void setMode(BlockPropertyStructureMode var0) {
        this.mode = var0;
        IBlockData var1 = this.level.getBlockState(this.getBlockPos());
        if (var1.is(Blocks.STRUCTURE_BLOCK)) {
            this.level.setBlock(this.getBlockPos(), (IBlockData)var1.setValue(BlockStructure.MODE, var0), 2);
        }
    }

    public boolean isIgnoreEntities() {
        return this.ignoreEntities;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setIgnoreEntities(boolean var0) {
        this.ignoreEntities = var0;
    }

    public void setStrict(boolean var0) {
        this.strict = var0;
    }

    public float getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(float var0) {
        this.integrity = var0;
    }

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long var0) {
        this.seed = var0;
    }

    public boolean detectSize() {
        if (this.mode != BlockPropertyStructureMode.SAVE) {
            return false;
        }
        BlockPosition var0 = this.getBlockPos();
        int var12 = 80;
        BlockPosition var2 = new BlockPosition(var0.getX() - 80, this.level.getMinY(), var0.getZ() - 80);
        BlockPosition var3 = new BlockPosition(var0.getX() + 80, this.level.getMaxY(), var0.getZ() + 80);
        Stream<BlockPosition> var4 = this.getRelatedCorners(var2, var3);
        return TileEntityStructure.calculateEnclosingBoundingBox(var0, var4).filter(var1 -> {
            int var2 = var1.maxX() - var1.minX();
            int var3 = var1.maxY() - var1.minY();
            int var4 = var1.maxZ() - var1.minZ();
            if (var2 > 1 && var3 > 1 && var4 > 1) {
                this.structurePos = new BlockPosition(var1.minX() - var0.getX() + 1, var1.minY() - var0.getY() + 1, var1.minZ() - var0.getZ() + 1);
                this.structureSize = new BaseBlockPosition(var2 - 1, var3 - 1, var4 - 1);
                this.setChanged();
                IBlockData var5 = this.level.getBlockState(var0);
                this.level.sendBlockUpdated(var0, var5, var5, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPosition> getRelatedCorners(BlockPosition var02, BlockPosition var1) {
        return BlockPosition.betweenClosedStream(var02, var1).filter(var0 -> this.level.getBlockState((BlockPosition)var0).is(Blocks.STRUCTURE_BLOCK)).map(this.level::getBlockEntity).filter(var0 -> var0 instanceof TileEntityStructure).map(var0 -> (TileEntityStructure)var0).filter(var0 -> var0.mode == BlockPropertyStructureMode.CORNER && Objects.equals(this.structureName, var0.structureName)).map(TileEntity::getBlockPos);
    }

    private static Optional<StructureBoundingBox> calculateEnclosingBoundingBox(BlockPosition var0, Stream<BlockPosition> var1) {
        Iterator var2 = var1.iterator();
        if (!var2.hasNext()) {
            return Optional.empty();
        }
        BlockPosition var3 = (BlockPosition)var2.next();
        StructureBoundingBox var4 = new StructureBoundingBox(var3);
        if (var2.hasNext()) {
            var2.forEachRemaining(var4::encapsulate);
        } else {
            var4.encapsulate(var0);
        }
        return Optional.of(var4);
    }

    public boolean saveStructure() {
        if (this.mode != BlockPropertyStructureMode.SAVE) {
            return false;
        }
        return this.saveStructure(true);
    }

    public boolean saveStructure(boolean var0) {
        World world;
        if (this.structureName == null || !((world = this.level) instanceof WorldServer)) {
            return false;
        }
        WorldServer var1 = (WorldServer)world;
        BlockPosition var2 = this.getBlockPos().offset(this.structurePos);
        return TileEntityStructure.saveStructure(var1, this.structureName, var2, this.structureSize, this.ignoreEntities, this.author, var0, List.of());
    }

    public static boolean saveStructure(WorldServer var0, MinecraftKey var1, BlockPosition var2, BaseBlockPosition var3, boolean var4, String var5, boolean var6, List<Block> var7) {
        DefinedStructure var9;
        StructureTemplateManager var8 = var0.getStructureManager();
        try {
            var9 = var8.getOrCreate(var1);
        }
        catch (ResourceKeyInvalidException var10) {
            return false;
        }
        var9.fillFromWorld(var0, var2, var3, !var4, Stream.concat(var7.stream(), Stream.of(Blocks.STRUCTURE_VOID)).toList());
        var9.setAuthor(var5);
        if (var6) {
            try {
                return var8.save(var1);
            }
            catch (ResourceKeyInvalidException var10) {
                return false;
            }
        }
        return true;
    }

    public static RandomSource createRandom(long var0) {
        if (var0 == 0L) {
            return RandomSource.create(SystemUtils.getMillis());
        }
        return RandomSource.create(var0);
    }

    public boolean placeStructureIfSameSize(WorldServer var0) {
        if (this.mode != BlockPropertyStructureMode.LOAD || this.structureName == null) {
            return false;
        }
        DefinedStructure var1 = var0.getStructureManager().get(this.structureName).orElse(null);
        if (var1 == null) {
            return false;
        }
        if (var1.getSize().equals(this.structureSize)) {
            this.placeStructure(var0, var1);
            return true;
        }
        this.loadStructureInfo(var1);
        return false;
    }

    public boolean loadStructureInfo(WorldServer var0) {
        DefinedStructure var1 = this.getStructureTemplate(var0);
        if (var1 == null) {
            return false;
        }
        this.loadStructureInfo(var1);
        return true;
    }

    private void loadStructureInfo(DefinedStructure var0) {
        this.author = !UtilColor.isNullOrEmpty(var0.getAuthor()) ? var0.getAuthor() : "";
        this.structureSize = var0.getSize();
        this.setChanged();
    }

    public void placeStructure(WorldServer var0) {
        DefinedStructure var1 = this.getStructureTemplate(var0);
        if (var1 != null) {
            this.placeStructure(var0, var1);
        }
    }

    private @Nullable DefinedStructure getStructureTemplate(WorldServer var0) {
        if (this.structureName == null) {
            return null;
        }
        return var0.getStructureManager().get(this.structureName).orElse(null);
    }

    private void placeStructure(WorldServer var0, DefinedStructure var12) {
        this.loadStructureInfo(var12);
        DefinedStructureInfo var2 = new DefinedStructureInfo().setMirror(this.mirror).setRotation(this.rotation).setIgnoreEntities(this.ignoreEntities).setKnownShape(this.strict);
        if (this.integrity < 1.0f) {
            var2.clearProcessors().addProcessor(new DefinedStructureProcessorRotation(MathHelper.clamp(this.integrity, 0.0f, 1.0f))).setRandom(TileEntityStructure.createRandom(this.seed));
        }
        BlockPosition var3 = this.getBlockPos().offset(this.structurePos);
        if (SharedConstants.DEBUG_STRUCTURE_EDIT_MODE) {
            BlockPosition.betweenClosed(var3, var3.offset(this.structureSize)).forEach(var1 -> var0.setBlock((BlockPosition)var1, Blocks.STRUCTURE_VOID.defaultBlockState(), 2));
        }
        var12.placeInWorld(var0, var3, var3, var2, TileEntityStructure.createRandom(this.seed), 2 | (this.strict ? 816 : 0));
    }

    public void unloadStructure() {
        if (this.structureName == null) {
            return;
        }
        WorldServer var0 = (WorldServer)this.level;
        StructureTemplateManager var1 = var0.getStructureManager();
        var1.remove(this.structureName);
    }

    public boolean isStructureLoadable() {
        if (this.mode != BlockPropertyStructureMode.LOAD || this.level.isClientSide() || this.structureName == null) {
            return false;
        }
        WorldServer var0 = (WorldServer)this.level;
        StructureTemplateManager var1 = var0.getStructureManager();
        try {
            return var1.get(this.structureName).isPresent();
        }
        catch (ResourceKeyInvalidException var2) {
            return false;
        }
    }

    public boolean isPowered() {
        return this.powered;
    }

    public void setPowered(boolean var0) {
        this.powered = var0;
    }

    public boolean getShowAir() {
        return this.showAir;
    }

    public void setShowAir(boolean var0) {
        this.showAir = var0;
    }

    public boolean getShowBoundingBox() {
        return this.showBoundingBox;
    }

    public void setShowBoundingBox(boolean var0) {
        this.showBoundingBox = var0;
    }

    @Override
    public BoundingBoxRenderable.a renderMode() {
        if (this.mode != BlockPropertyStructureMode.SAVE && this.mode != BlockPropertyStructureMode.LOAD) {
            return BoundingBoxRenderable.a.NONE;
        }
        if (this.mode == BlockPropertyStructureMode.SAVE && this.showAir) {
            return BoundingBoxRenderable.a.BOX_AND_INVISIBLE_BLOCKS;
        }
        if (this.mode == BlockPropertyStructureMode.SAVE || this.showBoundingBox) {
            return BoundingBoxRenderable.a.BOX;
        }
        return BoundingBoxRenderable.a.NONE;
    }

    @Override
    public BoundingBoxRenderable.b getRenderableBox() {
        int var9;
        int var8;
        int var6;
        int var4;
        BlockPosition var0 = this.getStructurePos();
        BaseBlockPosition var1 = this.getStructureSize();
        int var2 = var0.getX();
        int var3 = var0.getZ();
        int var7 = var0.getY();
        int var10 = var7 + var1.getY();
        return BoundingBoxRenderable.b.fromCorners(var6, var7, var8, var9, var10, switch (this.rotation) {
            case EnumBlockRotation.CLOCKWISE_90 -> {
                var6 = (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var2 : var2 + 1;
                var8 = var4 < 0 ? var3 + 1 : var3;
                var9 = var6 - (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
                yield var8 + var4;
            }
            case EnumBlockRotation.CLOCKWISE_180 -> {
                var6 = var4 < 0 ? var2 : var2 + 1;
                var8 = (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var3 : var3 + 1;
                var9 = var6 - var4;
                yield var8 - (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
            }
            case EnumBlockRotation.COUNTERCLOCKWISE_90 -> {
                var6 = (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var2 + 1 : var2;
                var8 = var4 < 0 ? var3 : var3 + 1;
                var9 = var6 + (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
                yield var8 - var4;
            }
            default -> {
                var6 = var4 < 0 ? var2 + 1 : var2;
                var8 = (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                }) < 0 ? var3 + 1 : var3;
                var9 = var6 + var4;
                yield var8 + (switch (this.mirror) {
                    case EnumBlockMirror.LEFT_RIGHT -> {
                        var4 = var1.getX();
                        yield -var1.getZ();
                    }
                    case EnumBlockMirror.FRONT_BACK -> {
                        var4 = -var1.getX();
                        yield var1.getZ();
                    }
                    default -> {
                        var4 = var1.getX();
                        yield var1.getZ();
                    }
                });
            }
        });
    }

    public /* synthetic */ Packet getUpdatePacket() {
        return this.getUpdatePacket();
    }

    public static final class UpdateType
    extends Enum<UpdateType> {
        public static final /* enum */ UpdateType UPDATE_DATA = new UpdateType();
        public static final /* enum */ UpdateType SAVE_AREA = new UpdateType();
        public static final /* enum */ UpdateType LOAD_AREA = new UpdateType();
        public static final /* enum */ UpdateType SCAN_AREA = new UpdateType();
        private static final /* synthetic */ UpdateType[] e;

        public static UpdateType[] values() {
            return (UpdateType[])e.clone();
        }

        public static UpdateType valueOf(String var0) {
            return Enum.valueOf(UpdateType.class, var0);
        }

        private static /* synthetic */ UpdateType[] a() {
            return new UpdateType[]{UPDATE_DATA, SAVE_AREA, LOAD_AREA, SCAN_AREA};
        }

        static {
            e = UpdateType.a();
        }
    }
}

