/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.sounds;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;

public class AmbientDesertBlockSoundsPlayer {
    private static final int IDLE_SOUND_CHANCE = 2100;
    private static final int DRY_GRASS_SOUND_CHANCE = 200;
    private static final int DEAD_BUSH_SOUND_CHANCE = 130;
    private static final int DEAD_BUSH_SOUND_BADLANDS_DECREASED_CHANCE = 3;
    private static final int SURROUNDING_BLOCKS_PLAY_SOUND_THRESHOLD = 3;
    private static final int SURROUNDING_BLOCKS_DISTANCE_HORIZONTAL_CHECK = 8;
    private static final int SURROUNDING_BLOCKS_DISTANCE_VERTICAL_CHECK = 5;
    private static final int HORIZONTAL_DIRECTIONS = 4;

    public static void playAmbientSandSounds(World var0, BlockPosition var1, RandomSource var2) {
        if (!var0.getBlockState(var1.above()).is(Blocks.AIR)) {
            return;
        }
        if (var2.nextInt(2100) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayAmbientSandSound(var0, var1)) {
            var0.playLocalSound(var1.getX(), var1.getY(), var1.getZ(), SoundEffects.SAND_IDLE, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    public static void playAmbientDryGrassSounds(World var0, BlockPosition var1, RandomSource var2) {
        if (var2.nextInt(200) == 0 && AmbientDesertBlockSoundsPlayer.shouldPlayDesertDryVegetationBlockSounds(var0, var1.below())) {
            var0.playPlayerSound(SoundEffects.DRY_GRASS, SoundCategory.AMBIENT, 1.0f, 1.0f);
        }
    }

    public static void playAmbientDeadBushSounds(World var0, BlockPosition var1, RandomSource var2) {
        if (var2.nextInt(130) == 0) {
            IBlockData var3 = var0.getBlockState(var1.below());
            if ((var3.is(Blocks.RED_SAND) || var3.is(TagsBlock.TERRACOTTA)) && var2.nextInt(3) != 0) {
                return;
            }
            if (AmbientDesertBlockSoundsPlayer.shouldPlayDesertDryVegetationBlockSounds(var0, var1.below())) {
                var0.playLocalSound(var1.getX(), var1.getY(), var1.getZ(), SoundEffects.DEAD_BUSH_IDLE, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            }
        }
    }

    public static boolean shouldPlayDesertDryVegetationBlockSounds(World var0, BlockPosition var1) {
        return var0.getBlockState(var1).is(TagsBlock.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS) && var0.getBlockState(var1.below()).is(TagsBlock.TRIGGERS_AMBIENT_DESERT_DRY_VEGETATION_BLOCK_SOUNDS);
    }

    private static boolean shouldPlayAmbientSandSound(World var0, BlockPosition var1) {
        int var2 = 0;
        int var3 = 0;
        BlockPosition.MutableBlockPosition var4 = var1.mutable();
        for (EnumDirection var6 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
            int var7;
            int var8;
            boolean var9;
            var4.set(var1).move(var6, 8);
            if (AmbientDesertBlockSoundsPlayer.columnContainsTriggeringBlock(var0, var4) && var2++ >= 3) {
                return true;
            }
            if (var9 = (var8 = (var7 = 4 - ++var3) + var2) >= 3) continue;
            return false;
        }
        return false;
    }

    private static boolean columnContainsTriggeringBlock(World var0, BlockPosition.MutableBlockPosition var1) {
        int var2 = var0.getHeight(HeightMap.Type.WORLD_SURFACE, var1) - 1;
        if (Math.abs(var2 - var1.getY()) <= 5) {
            boolean var3 = var0.getBlockState(var1.setY(var2 + 1)).isAir();
            return var3 && AmbientDesertBlockSoundsPlayer.canTriggerAmbientDesertSandSounds(var0.getBlockState(var1.setY(var2)));
        }
        var1.move(EnumDirection.UP, 6);
        IBlockData var3 = var0.getBlockState(var1);
        var1.move(EnumDirection.DOWN);
        for (int var4 = 0; var4 < 10; ++var4) {
            IBlockData var5 = var0.getBlockState(var1);
            if (var3.isAir() && AmbientDesertBlockSoundsPlayer.canTriggerAmbientDesertSandSounds(var5)) {
                return true;
            }
            var3 = var5;
            var1.move(EnumDirection.DOWN);
        }
        return false;
    }

    private static boolean canTriggerAmbientDesertSandSounds(IBlockData var0) {
        return var0.is(TagsBlock.TRIGGERS_AMBIENT_DESERT_SAND_BLOCK_SOUNDS);
    }
}

