/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.pattern;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jspecify.annotations.Nullable;

public class ShapeDetectorBuilder {
    private final List<String[]> pattern = Lists.newArrayList();
    private final Map<Character, Predicate<@Nullable ShapeDetectorBlock>> lookup = Maps.newHashMap();
    private int height;
    private int width;
    private final CharSet unknownCharacters = new CharOpenHashSet();

    private ShapeDetectorBuilder() {
        this.lookup.put(Character.valueOf(' '), var0 -> true);
    }

    public ShapeDetectorBuilder aisle(String ... var0) {
        if (ArrayUtils.isEmpty((Object[])var0) || StringUtils.isEmpty((CharSequence)var0[0])) {
            throw new IllegalArgumentException("Empty pattern for aisle");
        }
        if (this.pattern.isEmpty()) {
            this.height = var0.length;
            this.width = var0[0].length();
        }
        if (var0.length != this.height) {
            throw new IllegalArgumentException("Expected aisle with height of " + this.height + ", but was given one with a height of " + var0.length + ")");
        }
        for (String var4 : var0) {
            if (var4.length() != this.width) {
                throw new IllegalArgumentException("Not all rows in the given aisle are the correct width (expected " + this.width + ", found one with " + var4.length() + ")");
            }
            for (char var8 : var4.toCharArray()) {
                if (this.lookup.containsKey(Character.valueOf(var8))) continue;
                this.unknownCharacters.add(var8);
            }
        }
        this.pattern.add(var0);
        return this;
    }

    public static ShapeDetectorBuilder start() {
        return new ShapeDetectorBuilder();
    }

    public ShapeDetectorBuilder where(char var0, Predicate<@Nullable ShapeDetectorBlock> var1) {
        this.lookup.put(Character.valueOf(var0), var1);
        this.unknownCharacters.remove(var0);
        return this;
    }

    public ShapeDetector build() {
        return new ShapeDetector(this.createPattern());
    }

    private Predicate<ShapeDetectorBlock>[][][] createPattern() {
        if (!this.unknownCharacters.isEmpty()) {
            throw new IllegalStateException("Predicates for character(s) " + String.valueOf(this.unknownCharacters) + " are missing");
        }
        Predicate[][][] var0 = (Predicate[][][])Array.newInstance(Predicate.class, this.pattern.size(), this.height, this.width);
        for (int var1 = 0; var1 < this.pattern.size(); ++var1) {
            for (int var2 = 0; var2 < this.height; ++var2) {
                for (int var3 = 0; var3 < this.width; ++var3) {
                    var0[var1][var2][var3] = this.lookup.get(Character.valueOf(this.pattern.get(var1)[var2].charAt(var3)));
                }
            }
        }
        return var0;
    }
}

