/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import it.unimi.dsi.fastutil.ints.IntImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.world.level.block.state.properties.IBlockState;

public final class BlockStateInteger
extends IBlockState<Integer> {
    private final IntImmutableList values;
    public final int min;
    public final int max;

    private BlockStateInteger(String var0, int var1, int var2) {
        super(var0, Integer.class);
        if (var1 < 0) {
            throw new IllegalArgumentException("Min value of " + var0 + " must be 0 or greater");
        }
        if (var2 <= var1) {
            throw new IllegalArgumentException("Max value of " + var0 + " must be greater than min (" + var1 + ")");
        }
        this.min = var1;
        this.max = var2;
        this.values = IntImmutableList.toList((IntStream)IntStream.range(var1, var2 + 1));
    }

    @Override
    public List<Integer> getPossibleValues() {
        return this.values;
    }

    @Override
    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof BlockStateInteger) {
            BlockStateInteger var1 = (BlockStateInteger)var0;
            if (super.equals(var0)) {
                return this.values.equals(var1.values);
            }
        }
        return false;
    }

    @Override
    public int generateHashCode() {
        return 31 * super.generateHashCode() + this.values.hashCode();
    }

    public static BlockStateInteger create(String var0, int var1, int var2) {
        return new BlockStateInteger(var0, var1, var2);
    }

    @Override
    public Optional<Integer> getValue(String var0) {
        try {
            int var1 = Integer.parseInt(var0);
            return var1 >= this.min && var1 <= this.max ? Optional.of(var1) : Optional.empty();
        }
        catch (NumberFormatException var1) {
            return Optional.empty();
        }
    }

    @Override
    public String getName(Integer var0) {
        return var0.toString();
    }

    @Override
    public int getInternalIndex(Integer var0) {
        if (var0 <= this.max) {
            return var0 - this.min;
        }
        return -1;
    }

    @Override
    public /* synthetic */ int getInternalIndex(Comparable comparable) {
        return this.getInternalIndex((Integer)comparable);
    }

    @Override
    public /* synthetic */ String getName(Comparable comparable) {
        return this.getName((Integer)comparable);
    }
}

