/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.jspecify.annotations.Nullable;

public class SimpleRegionStorage
implements AutoCloseable {
    private final IOWorker worker;
    private final DataFixer fixerUpper;
    private final DataFixTypes dataFixType;
    private final Supplier<LegacyTagFixer> legacyFixer;

    public SimpleRegionStorage(RegionStorageInfo var0, Path var1, DataFixer var2, boolean var3, DataFixTypes var4) {
        this(var0, var1, var2, var3, var4, LegacyTagFixer.EMPTY);
    }

    public SimpleRegionStorage(RegionStorageInfo var0, Path var1, DataFixer var2, boolean var3, DataFixTypes var4, Supplier<LegacyTagFixer> var5) {
        this.fixerUpper = var2;
        this.dataFixType = var4;
        this.worker = new IOWorker(var0, var1, var3);
        this.legacyFixer = Suppliers.memoize(var5::get);
    }

    public boolean isOldChunkAround(ChunkCoordIntPair var0, int var1) {
        return this.worker.isOldChunkAround(var0, var1);
    }

    public CompletableFuture<Optional<NBTTagCompound>> read(ChunkCoordIntPair var0) {
        return this.worker.loadAsync(var0);
    }

    public CompletableFuture<Void> write(ChunkCoordIntPair var0, NBTTagCompound var1) {
        return this.write(var0, () -> var1);
    }

    public CompletableFuture<Void> write(ChunkCoordIntPair var0, Supplier<NBTTagCompound> var1) {
        this.markChunkDone(var0);
        return this.worker.store(var0, var1);
    }

    public NBTTagCompound upgradeChunkTag(NBTTagCompound var0, int var1, @Nullable NBTTagCompound var2) {
        int var3 = GameProfileSerializer.getDataVersion(var0, var1);
        if (var3 == SharedConstants.getCurrentVersion().dataVersion().version()) {
            return var0;
        }
        try {
            var0 = this.legacyFixer.get().applyFix(var0);
            SimpleRegionStorage.injectDatafixingContext(var0, var2);
            var0 = this.dataFixType.updateToCurrentVersion(this.fixerUpper, var0, Math.max(this.legacyFixer.get().targetDataVersion(), var3));
            SimpleRegionStorage.removeDatafixingContext(var0);
            GameProfileSerializer.addCurrentDataVersion(var0);
            return var0;
        }
        catch (Exception var4) {
            CrashReport var5 = CrashReport.forThrowable(var4, "Updated chunk");
            CrashReportSystemDetails var6 = var5.addCategory("Updated chunk details");
            var6.setDetail("Data version", var3);
            throw new ReportedException(var5);
        }
    }

    public NBTTagCompound upgradeChunkTag(NBTTagCompound var0, int var1) {
        return this.upgradeChunkTag(var0, var1, null);
    }

    public Dynamic<NBTBase> upgradeChunkTag(Dynamic<NBTBase> var0, int var1) {
        return new Dynamic(var0.getOps(), (Object)this.upgradeChunkTag((NBTTagCompound)var0.getValue(), var1, null));
    }

    public static void injectDatafixingContext(NBTTagCompound var0, @Nullable NBTTagCompound var1) {
        if (var1 != null) {
            var0.put("__context", var1);
        }
    }

    private static void removeDatafixingContext(NBTTagCompound var0) {
        var0.remove("__context");
    }

    protected void markChunkDone(ChunkCoordIntPair var0) {
        this.legacyFixer.get().markChunkDone(var0);
    }

    public CompletableFuture<Void> synchronize(boolean var0) {
        return this.worker.synchronize(var0);
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }

    public ChunkScanAccess chunkScanner() {
        return this.worker;
    }

    public RegionStorageInfo storageInfo() {
        return this.worker.storageInfo();
    }
}

