/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.nio.file.Path;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.INamable;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.attribute.EnvironmentAttributeMap;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.timeline.Timeline;

public record DimensionManager(boolean hasFixedTime, boolean hasSkyLight, boolean hasCeiling, double coordinateScale, int minY, int height, int logicalHeight, TagKey<Block> infiniburn, float ambientLight, b monsterSettings, c skybox, a cardinalLightType, EnvironmentAttributeMap attributes, HolderSet<Timeline> timelines) {
    public static final int BITS_FOR_Y = BlockPosition.PACKED_Y_LENGTH;
    public static final int MIN_HEIGHT = 16;
    public static final int Y_SIZE = (1 << BITS_FOR_Y) - 32;
    public static final int MAX_Y = (Y_SIZE >> 1) - 1;
    public static final int MIN_Y = MAX_Y - Y_SIZE + 1;
    public static final int WAY_ABOVE_MAX_Y = MAX_Y << 4;
    public static final int WAY_BELOW_MIN_Y = MIN_Y << 4;
    public static final Codec<DimensionManager> DIRECT_CODEC = DimensionManager.createDirectCodec(EnvironmentAttributeMap.CODEC);
    public static final Codec<DimensionManager> NETWORK_CODEC = DimensionManager.createDirectCodec(EnvironmentAttributeMap.NETWORK_CODEC);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<DimensionManager>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.DIMENSION_TYPE);
    public static final float[] MOON_BRIGHTNESS_PER_PHASE = new float[]{1.0f, 0.75f, 0.5f, 0.25f, 0.0f, 0.25f, 0.5f, 0.75f};
    public static final Codec<Holder<DimensionManager>> CODEC = RegistryFileCodec.create(Registries.DIMENSION_TYPE, DIRECT_CODEC);

    public DimensionManager {
        if (var6 < 16) {
            throw new IllegalStateException("height has to be at least 16");
        }
        if (var5 + var6 > MAX_Y + 1) {
            throw new IllegalStateException("min_y + height cannot be higher than: " + (MAX_Y + 1));
        }
        if (var7 > var6) {
            throw new IllegalStateException("logical_height cannot be higher than height");
        }
        if (var6 % 16 != 0) {
            throw new IllegalStateException("height has to be multiple of 16");
        }
        if (var5 % 16 != 0) {
            throw new IllegalStateException("min_y has to be a multiple of 16");
        }
    }

    private static Codec<DimensionManager> createDirectCodec(Codec<EnvironmentAttributeMap> var0) {
        return ExtraCodecs.catchDecoderException(RecordCodecBuilder.create(var1 -> var1.group((App)Codec.BOOL.optionalFieldOf("has_fixed_time", (Object)false).forGetter(DimensionManager::hasFixedTime), (App)Codec.BOOL.fieldOf("has_skylight").forGetter(DimensionManager::hasSkyLight), (App)Codec.BOOL.fieldOf("has_ceiling").forGetter(DimensionManager::hasCeiling), (App)Codec.doubleRange((double)1.0E-5f, (double)3.0E7).fieldOf("coordinate_scale").forGetter(DimensionManager::coordinateScale), (App)Codec.intRange((int)MIN_Y, (int)MAX_Y).fieldOf("min_y").forGetter(DimensionManager::minY), (App)Codec.intRange((int)16, (int)Y_SIZE).fieldOf("height").forGetter(DimensionManager::height), (App)Codec.intRange((int)0, (int)Y_SIZE).fieldOf("logical_height").forGetter(DimensionManager::logicalHeight), (App)TagKey.hashedCodec(Registries.BLOCK).fieldOf("infiniburn").forGetter(DimensionManager::infiniburn), (App)Codec.FLOAT.fieldOf("ambient_light").forGetter(DimensionManager::ambientLight), (App)b.CODEC.forGetter(DimensionManager::monsterSettings), (App)c.CODEC.optionalFieldOf("skybox", (Object)c.OVERWORLD).forGetter(DimensionManager::skybox), (App)a.CODEC.optionalFieldOf("cardinal_light", (Object)a.DEFAULT).forGetter(DimensionManager::cardinalLightType), (App)var0.optionalFieldOf("attributes", (Object)EnvironmentAttributeMap.EMPTY).forGetter(DimensionManager::attributes), (App)RegistryCodecs.homogeneousList(Registries.TIMELINE).optionalFieldOf("timelines", HolderSet.empty()).forGetter(DimensionManager::timelines)).apply((Applicative)var1, DimensionManager::new)));
    }

    public static double getTeleportationScale(DimensionManager var0, DimensionManager var1) {
        double var2 = var0.coordinateScale();
        double var4 = var1.coordinateScale();
        return var2 / var4;
    }

    public static Path getStorageFolder(ResourceKey<World> var0, Path var1) {
        if (var0 == World.OVERWORLD) {
            return var1;
        }
        if (var0 == World.END) {
            return var1.resolve("DIM1");
        }
        if (var0 == World.NETHER) {
            return var1.resolve("DIM-1");
        }
        return var1.resolve("dimensions").resolve(var0.identifier().getNamespace()).resolve(var0.identifier().getPath());
    }

    public IntProvider monsterSpawnLightTest() {
        return this.monsterSettings.monsterSpawnLightTest();
    }

    public int monsterSpawnBlockLightLimit() {
        return this.monsterSettings.monsterSpawnBlockLightLimit();
    }

    public boolean hasEndFlashes() {
        return this.skybox == c.END;
    }

    public record b(IntProvider monsterSpawnLightTest, int monsterSpawnBlockLightLimit) {
        public static final MapCodec<b> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)IntProvider.codec(0, 15).fieldOf("monster_spawn_light_level").forGetter(b::monsterSpawnLightTest), (App)Codec.intRange((int)0, (int)15).fieldOf("monster_spawn_block_light_limit").forGetter(b::monsterSpawnBlockLightLimit)).apply((Applicative)var0, b::new));
    }

    public static final class c
    extends Enum<c>
    implements INamable {
        public static final /* enum */ c NONE = new c("none");
        public static final /* enum */ c OVERWORLD = new c("overworld");
        public static final /* enum */ c END = new c("end");
        public static final Codec<c> CODEC;
        private final String name;
        private static final /* synthetic */ c[] f;

        public static c[] values() {
            return (c[])f.clone();
        }

        public static c valueOf(String var0) {
            return Enum.valueOf(c.class, var0);
        }

        private c(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ c[] a() {
            return new c[]{NONE, OVERWORLD, END};
        }

        static {
            f = c.a();
            CODEC = INamable.fromEnum(c::values);
        }
    }

    public static final class a
    extends Enum<a>
    implements INamable {
        public static final /* enum */ a DEFAULT = new a("default");
        public static final /* enum */ a NETHER = new a("nether");
        public static final Codec<a> CODEC;
        private final String name;
        private static final /* synthetic */ a[] e;

        public static a[] values() {
            return (a[])e.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ a[] a() {
            return new a[]{DEFAULT, NETHER};
        }

        static {
            e = a.a();
            CODEC = INamable.fromEnum(a::values);
        }
    }
}

