/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent;

import java.util.function.Consumer;
import net.minecraft.core.SectionPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import org.jspecify.annotations.Nullable;

public class DynamicGameEventListener<T extends GameEventListener> {
    private final T listener;
    private @Nullable SectionPosition lastSection;

    public DynamicGameEventListener(T var0) {
        this.listener = var0;
    }

    public void add(WorldServer var0) {
        this.move(var0);
    }

    public T getListener() {
        return this.listener;
    }

    public void remove(WorldServer var02) {
        DynamicGameEventListener.ifChunkExists(var02, this.lastSection, var0 -> var0.unregister((GameEventListener)this.listener));
    }

    public void move(WorldServer var0) {
        this.listener.getListenerSource().getPosition(var0).map(SectionPosition::of).ifPresent(var1 -> {
            if (this.lastSection == null || !this.lastSection.equals(var1)) {
                DynamicGameEventListener.ifChunkExists(var0, this.lastSection, var0 -> var0.unregister((GameEventListener)this.listener));
                this.lastSection = var1;
                DynamicGameEventListener.ifChunkExists(var0, this.lastSection, var0 -> var0.register((GameEventListener)this.listener));
            }
        });
    }

    private static void ifChunkExists(IWorldReader var0, @Nullable SectionPosition var1, Consumer<GameEventListenerRegistry> var2) {
        if (var1 == null) {
            return;
        }
        IChunkAccess var3 = var0.getChunk(var1.x(), var1.z(), ChunkStatus.FULL, false);
        if (var3 != null) {
            var2.accept(var3.getListenerRegistry(var1.y()));
        }
    }
}

