/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gameevent.vibrations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.ToIntFunction;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.VibrationParticleOption;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.ClipBlockStateContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationInfo;
import net.minecraft.world.level.gameevent.vibrations.VibrationSelector;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;
import org.jspecify.annotations.Nullable;

public interface VibrationSystem {
    public static final List<ResourceKey<GameEvent>> RESONANCE_EVENTS = List.of(GameEvent.RESONATE_1.key(), GameEvent.RESONATE_2.key(), GameEvent.RESONATE_3.key(), GameEvent.RESONATE_4.key(), GameEvent.RESONATE_5.key(), GameEvent.RESONATE_6.key(), GameEvent.RESONATE_7.key(), GameEvent.RESONATE_8.key(), GameEvent.RESONATE_9.key(), GameEvent.RESONATE_10.key(), GameEvent.RESONATE_11.key(), GameEvent.RESONATE_12.key(), GameEvent.RESONATE_13.key(), GameEvent.RESONATE_14.key(), GameEvent.RESONATE_15.key());
    public static final int NO_VIBRATION_FREQUENCY = 0;
    public static final ToIntFunction<ResourceKey<GameEvent>> VIBRATION_FREQUENCY_FOR_EVENT = (ToIntFunction)SystemUtils.make(new Reference2IntOpenHashMap(), var0 -> {
        var0.defaultReturnValue(0);
        var0.put(GameEvent.STEP.key(), 1);
        var0.put(GameEvent.SWIM.key(), 1);
        var0.put(GameEvent.FLAP.key(), 1);
        var0.put(GameEvent.PROJECTILE_LAND.key(), 2);
        var0.put(GameEvent.HIT_GROUND.key(), 2);
        var0.put(GameEvent.SPLASH.key(), 2);
        var0.put(GameEvent.ITEM_INTERACT_FINISH.key(), 3);
        var0.put(GameEvent.PROJECTILE_SHOOT.key(), 3);
        var0.put(GameEvent.INSTRUMENT_PLAY.key(), 3);
        var0.put(GameEvent.ENTITY_ACTION.key(), 4);
        var0.put(GameEvent.ELYTRA_GLIDE.key(), 4);
        var0.put(GameEvent.UNEQUIP.key(), 4);
        var0.put(GameEvent.ENTITY_DISMOUNT.key(), 5);
        var0.put(GameEvent.EQUIP.key(), 5);
        var0.put(GameEvent.ENTITY_INTERACT.key(), 6);
        var0.put(GameEvent.SHEAR.key(), 6);
        var0.put(GameEvent.ENTITY_MOUNT.key(), 6);
        var0.put(GameEvent.ENTITY_DAMAGE.key(), 7);
        var0.put(GameEvent.DRINK.key(), 8);
        var0.put(GameEvent.EAT.key(), 8);
        var0.put(GameEvent.CONTAINER_CLOSE.key(), 9);
        var0.put(GameEvent.BLOCK_CLOSE.key(), 9);
        var0.put(GameEvent.BLOCK_DEACTIVATE.key(), 9);
        var0.put(GameEvent.BLOCK_DETACH.key(), 9);
        var0.put(GameEvent.CONTAINER_OPEN.key(), 10);
        var0.put(GameEvent.BLOCK_OPEN.key(), 10);
        var0.put(GameEvent.BLOCK_ACTIVATE.key(), 10);
        var0.put(GameEvent.BLOCK_ATTACH.key(), 10);
        var0.put(GameEvent.PRIME_FUSE.key(), 10);
        var0.put(GameEvent.NOTE_BLOCK_PLAY.key(), 10);
        var0.put(GameEvent.BLOCK_CHANGE.key(), 11);
        var0.put(GameEvent.BLOCK_DESTROY.key(), 12);
        var0.put(GameEvent.FLUID_PICKUP.key(), 12);
        var0.put(GameEvent.BLOCK_PLACE.key(), 13);
        var0.put(GameEvent.FLUID_PLACE.key(), 13);
        var0.put(GameEvent.ENTITY_PLACE.key(), 14);
        var0.put(GameEvent.LIGHTNING_STRIKE.key(), 14);
        var0.put(GameEvent.TELEPORT.key(), 14);
        var0.put(GameEvent.ENTITY_DIE.key(), 15);
        var0.put(GameEvent.EXPLODE.key(), 15);
        for (int var1 = 1; var1 <= 15; ++var1) {
            var0.put(VibrationSystem.getResonanceEventByFrequency(var1), var1);
        }
    });

    public a getVibrationData();

    public d getVibrationUser();

    public static int getGameEventFrequency(Holder<GameEvent> var0) {
        return var0.unwrapKey().map(VibrationSystem::getGameEventFrequency).orElse(0);
    }

    public static int getGameEventFrequency(ResourceKey<GameEvent> var0) {
        return VIBRATION_FREQUENCY_FOR_EVENT.applyAsInt(var0);
    }

    public static ResourceKey<GameEvent> getResonanceEventByFrequency(int var0) {
        return RESONANCE_EVENTS.get(var0 - 1);
    }

    public static int getRedstoneStrengthForDistance(float var0, int var1) {
        double var2 = 15.0 / (double)var1;
        return Math.max(1, 15 - MathHelper.floor(var2 * (double)var0));
    }

    public static interface d {
        public int getListenerRadius();

        public PositionSource getPositionSource();

        public boolean canReceiveVibration(WorldServer var1, BlockPosition var2, Holder<GameEvent> var3, GameEvent.a var4);

        public void onReceiveVibration(WorldServer var1, BlockPosition var2, Holder<GameEvent> var3, @Nullable Entity var4, @Nullable Entity var5, float var6);

        default public TagKey<GameEvent> getListenableEvents() {
            return GameEventTags.VIBRATIONS;
        }

        default public boolean canTriggerAvoidVibration() {
            return false;
        }

        default public boolean requiresAdjacentChunksToBeTicking() {
            return false;
        }

        default public int calculateTravelTimeInTicks(float var0) {
            return MathHelper.floor(var0);
        }

        default public boolean isValidVibration(Holder<GameEvent> var0, GameEvent.a var1) {
            if (!var0.is(this.getListenableEvents())) {
                return false;
            }
            Entity var2 = var1.sourceEntity();
            if (var2 != null) {
                if (var2.isSpectator()) {
                    return false;
                }
                if (var2.isSteppingCarefully() && var0.is(GameEventTags.IGNORE_VIBRATIONS_SNEAKING)) {
                    if (this.canTriggerAvoidVibration() && var2 instanceof EntityPlayer) {
                        EntityPlayer var3 = (EntityPlayer)var2;
                        CriterionTriggers.AVOID_VIBRATION.trigger(var3);
                    }
                    return false;
                }
                if (var2.dampensVibrations()) {
                    return false;
                }
            }
            if (var1.affectedState() != null) {
                return !var1.affectedState().is(TagsBlock.DAMPENS_VIBRATIONS);
            }
            return true;
        }

        default public void onDataChanged() {
        }
    }

    public static interface c {
        public static void tick(World var0, a var1, d var2) {
            if (!(var0 instanceof WorldServer)) {
                return;
            }
            WorldServer var3 = (WorldServer)var0;
            if (var1.currentVibration == null) {
                c.trySelectAndScheduleVibration(var3, var1, var2);
            }
            if (var1.currentVibration == null) {
                return;
            }
            boolean var4 = var1.getTravelTimeInTicks() > 0;
            c.tryReloadVibrationParticle(var3, var1, var2);
            var1.decrementTravelTime();
            if (var1.getTravelTimeInTicks() <= 0) {
                var4 = c.receiveVibration(var3, var1, var2, var1.currentVibration);
            }
            if (var4) {
                var2.onDataChanged();
            }
        }

        private static void trySelectAndScheduleVibration(WorldServer var0, a var1, d var2) {
            var1.getSelectionStrategy().chosenCandidate(var0.getGameTime()).ifPresent(var3 -> {
                var1.setCurrentVibration((VibrationInfo)var3);
                Vec3D var4 = var3.pos();
                var1.setTravelTimeInTicks(var2.calculateTravelTimeInTicks(var3.distance()));
                var0.sendParticles(new VibrationParticleOption(var2.getPositionSource(), var1.getTravelTimeInTicks()), var4.x, var4.y, var4.z, 1, 0.0, 0.0, 0.0, 0.0);
                var2.onDataChanged();
                var1.getSelectionStrategy().startOver();
            });
        }

        private static void tryReloadVibrationParticle(WorldServer var0, a var1, d var2) {
            double var14;
            double var12;
            int var7;
            double var8;
            double var10;
            boolean var16;
            if (!var1.shouldReloadVibrationParticle()) {
                return;
            }
            if (var1.currentVibration == null) {
                var1.setReloadVibrationParticle(false);
                return;
            }
            Vec3D var3 = var1.currentVibration.pos();
            PositionSource var4 = var2.getPositionSource();
            Vec3D var5 = var4.getPosition(var0).orElse(var3);
            int var6 = var1.getTravelTimeInTicks();
            boolean bl = var16 = var0.sendParticles(new VibrationParticleOption(var4, var6), var10 = MathHelper.lerp(var8 = 1.0 - (double)var6 / (double)(var7 = var2.calculateTravelTimeInTicks(var1.currentVibration.distance())), var3.x, var5.x), var12 = MathHelper.lerp(var8, var3.y, var5.y), var14 = MathHelper.lerp(var8, var3.z, var5.z), 1, 0.0, 0.0, 0.0, 0.0) > 0;
            if (var16) {
                var1.setReloadVibrationParticle(false);
            }
        }

        private static boolean receiveVibration(WorldServer var0, a var1, d var2, VibrationInfo var3) {
            BlockPosition var4 = BlockPosition.containing(var3.pos());
            BlockPosition var5 = var2.getPositionSource().getPosition(var0).map(BlockPosition::containing).orElse(var4);
            if (var2.requiresAdjacentChunksToBeTicking() && !c.areAdjacentChunksTicking(var0, var5)) {
                return false;
            }
            var2.onReceiveVibration(var0, var4, var3.gameEvent(), var3.getEntity(var0).orElse(null), var3.getProjectileOwner(var0).orElse(null), b.distanceBetweenInBlocks(var4, var5));
            var1.setCurrentVibration(null);
            return true;
        }

        private static boolean areAdjacentChunksTicking(World var0, BlockPosition var1) {
            ChunkCoordIntPair var2 = new ChunkCoordIntPair(var1);
            for (int var3 = var2.x - 1; var3 <= var2.x + 1; ++var3) {
                for (int var4 = var2.z - 1; var4 <= var2.z + 1; ++var4) {
                    if (var0.shouldTickBlocksAt(ChunkCoordIntPair.asLong(var3, var4)) && var0.getChunkSource().getChunkNow(var3, var4) != null) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static class b
    implements GameEventListener {
        private final VibrationSystem system;

        public b(VibrationSystem var0) {
            this.system = var0;
        }

        @Override
        public PositionSource getListenerSource() {
            return this.system.getVibrationUser().getPositionSource();
        }

        @Override
        public int getListenerRadius() {
            return this.system.getVibrationUser().getListenerRadius();
        }

        @Override
        public boolean handleGameEvent(WorldServer var0, Holder<GameEvent> var1, GameEvent.a var2, Vec3D var3) {
            a var4 = this.system.getVibrationData();
            d var5 = this.system.getVibrationUser();
            if (var4.getCurrentVibration() != null) {
                return false;
            }
            if (!var5.isValidVibration(var1, var2)) {
                return false;
            }
            Optional<Vec3D> var6 = var5.getPositionSource().getPosition(var0);
            if (var6.isEmpty()) {
                return false;
            }
            Vec3D var7 = var6.get();
            if (!var5.canReceiveVibration(var0, BlockPosition.containing(var3), var1, var2)) {
                return false;
            }
            if (b.isOccluded(var0, var3, var7)) {
                return false;
            }
            this.scheduleVibration(var0, var4, var1, var2, var3, var7);
            return true;
        }

        public void forceScheduleVibration(WorldServer var0, Holder<GameEvent> var1, GameEvent.a var2, Vec3D var3) {
            this.system.getVibrationUser().getPositionSource().getPosition(var0).ifPresent(var4 -> this.scheduleVibration(var0, this.system.getVibrationData(), var1, var2, var3, (Vec3D)var4));
        }

        private void scheduleVibration(WorldServer var0, a var1, Holder<GameEvent> var2, GameEvent.a var3, Vec3D var4, Vec3D var5) {
            var1.selectionStrategy.addCandidate(new VibrationInfo(var2, (float)var4.distanceTo(var5), var4, var3.sourceEntity()), var0.getGameTime());
        }

        public static float distanceBetweenInBlocks(BlockPosition var0, BlockPosition var1) {
            return (float)Math.sqrt(var0.distSqr(var1));
        }

        private static boolean isOccluded(World var02, Vec3D var1, Vec3D var2) {
            Vec3D var3 = new Vec3D((double)MathHelper.floor(var1.x) + 0.5, (double)MathHelper.floor(var1.y) + 0.5, (double)MathHelper.floor(var1.z) + 0.5);
            Vec3D var4 = new Vec3D((double)MathHelper.floor(var2.x) + 0.5, (double)MathHelper.floor(var2.y) + 0.5, (double)MathHelper.floor(var2.z) + 0.5);
            for (EnumDirection var8 : EnumDirection.values()) {
                Vec3D var9 = var3.relative(var8, 1.0E-5f);
                if (var02.isBlockInLine(new ClipBlockStateContext(var9, var4, var0 -> var0.is(TagsBlock.OCCLUDES_VIBRATION_SIGNALS))).getType() == MovingObjectPosition.EnumMovingObjectType.BLOCK) continue;
                return false;
            }
            return true;
        }
    }

    public static final class a {
        public static Codec<a> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)VibrationInfo.CODEC.lenientOptionalFieldOf("event").forGetter(var0 -> Optional.ofNullable(var0.currentVibration)), (App)VibrationSelector.CODEC.fieldOf("selector").forGetter(a::getSelectionStrategy), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("event_delay").orElse((Object)0).forGetter(a::getTravelTimeInTicks)).apply((Applicative)var02, (var0, var1, var2) -> new a(var0.orElse(null), (VibrationSelector)var1, (int)var2, true)));
        public static final String NBT_TAG_KEY = "listener";
        @Nullable VibrationInfo currentVibration;
        private int travelTimeInTicks;
        final VibrationSelector selectionStrategy;
        private boolean reloadVibrationParticle;

        private a(@Nullable VibrationInfo var0, VibrationSelector var1, int var2, boolean var3) {
            this.currentVibration = var0;
            this.travelTimeInTicks = var2;
            this.selectionStrategy = var1;
            this.reloadVibrationParticle = var3;
        }

        public a() {
            this(null, new VibrationSelector(), 0, false);
        }

        public VibrationSelector getSelectionStrategy() {
            return this.selectionStrategy;
        }

        public @Nullable VibrationInfo getCurrentVibration() {
            return this.currentVibration;
        }

        public void setCurrentVibration(@Nullable VibrationInfo var0) {
            this.currentVibration = var0;
        }

        public int getTravelTimeInTicks() {
            return this.travelTimeInTicks;
        }

        public void setTravelTimeInTicks(int var0) {
            this.travelTimeInTicks = var0;
        }

        public void decrementTravelTime() {
            this.travelTimeInTicks = Math.max(0, this.travelTimeInTicks - 1);
        }

        public boolean shouldReloadVibrationParticle() {
            return this.reloadVibrationParticle;
        }

        public void setReloadVibrationParticle(boolean var0) {
            this.reloadVibrationParticle = var0;
        }
    }
}

