/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.resources.MinecraftKey;

public record GameRuleCategory(MinecraftKey id) {
    private static final List<GameRuleCategory> SORT_ORDER = new ArrayList<GameRuleCategory>();
    public static final GameRuleCategory PLAYER = GameRuleCategory.register("player");
    public static final GameRuleCategory MOBS = GameRuleCategory.register("mobs");
    public static final GameRuleCategory SPAWNING = GameRuleCategory.register("spawning");
    public static final GameRuleCategory DROPS = GameRuleCategory.register("drops");
    public static final GameRuleCategory UPDATES = GameRuleCategory.register("updates");
    public static final GameRuleCategory CHAT = GameRuleCategory.register("chat");
    public static final GameRuleCategory MISC = GameRuleCategory.register("misc");

    public MinecraftKey getDescriptionId() {
        return this.id;
    }

    private static GameRuleCategory register(String var0) {
        return GameRuleCategory.register(MinecraftKey.withDefaultNamespace(var0));
    }

    public static GameRuleCategory register(MinecraftKey var0) {
        GameRuleCategory var1 = new GameRuleCategory(var0);
        if (SORT_ORDER.contains(var1)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Category '%s' is already registered.", var0));
        }
        SORT_ORDER.add(var1);
        return var1;
    }

    public IChatMutableComponent label() {
        return IChatBaseComponent.translatable(this.id.toLanguageKey("gamerule.category"));
    }
}

