/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.gamerules.GameRule;
import org.jspecify.annotations.Nullable;

public final class GameRuleMap {
    public static final Codec<GameRuleMap> CODEC = Codec.dispatchedMap(BuiltInRegistries.GAME_RULE.byNameCodec(), GameRule::valueCodec).xmap(GameRuleMap::ofTrusted, GameRuleMap::map);
    private final Reference2ObjectMap<GameRule<?>, Object> map;

    GameRuleMap(Reference2ObjectMap<GameRule<?>, Object> var0) {
        this.map = var0;
    }

    private static GameRuleMap ofTrusted(Map<GameRule<?>, Object> var0) {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap(var0));
    }

    public static GameRuleMap of() {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap());
    }

    public static GameRuleMap of(Stream<GameRule<?>> var0) {
        Reference2ObjectOpenHashMap var12 = new Reference2ObjectOpenHashMap();
        var0.forEach(var1 -> var12.put(var1, var1.defaultValue()));
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)var12);
    }

    public static GameRuleMap copyOf(GameRuleMap var0) {
        return new GameRuleMap((Reference2ObjectMap<GameRule<?>, Object>)new Reference2ObjectOpenHashMap(var0.map));
    }

    public boolean has(GameRule<?> var0) {
        return this.map.containsKey(var0);
    }

    public <T> @Nullable T get(GameRule<T> var0) {
        return (T)this.map.get(var0);
    }

    public <T> void set(GameRule<T> var0, T var1) {
        this.map.put(var0, var1);
    }

    public <T> @Nullable T remove(GameRule<T> var0) {
        return (T)this.map.remove(var0);
    }

    public Set<GameRule<?>> keySet() {
        return this.map.keySet();
    }

    public int size() {
        return this.map.size();
    }

    public String toString() {
        return this.map.toString();
    }

    public GameRuleMap withOther(GameRuleMap var02) {
        GameRuleMap var1 = GameRuleMap.copyOf(this);
        var1.setFromIf(var02, var0 -> true);
        return var1;
    }

    public void setFromIf(GameRuleMap var0, Predicate<GameRule<?>> var1) {
        for (GameRule<?> var3 : var0.keySet()) {
            if (!var1.test(var3)) continue;
            GameRuleMap.setGameRule(var0, var3, this);
        }
    }

    private static <T> void setGameRule(GameRuleMap var0, GameRule<T> var1, GameRuleMap var2) {
        var2.set(var1, Objects.requireNonNull(var0.get(var1)));
    }

    private Reference2ObjectMap<GameRule<?>, Object> map() {
        return this.map;
    }

    public boolean equals(Object var0) {
        if (var0 == this) {
            return true;
        }
        if (var0 == null || var0.getClass() != this.getClass()) {
            return false;
        }
        GameRuleMap var1 = (GameRuleMap)var0;
        return Objects.equals(this.map, var1.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static class a {
        final Reference2ObjectMap<GameRule<?>, Object> map = new Reference2ObjectOpenHashMap();

        public <T> a set(GameRule<T> var0, T var1) {
            this.map.put(var0, var1);
            return this;
        }

        public GameRuleMap build() {
            return new GameRuleMap(this.map);
        }
    }
}

