/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.gamerules;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.serialization.Codec;
import java.util.Objects;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.SharedConstants;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.gamerules.GameRule;
import net.minecraft.world.level.gamerules.GameRuleCategory;
import net.minecraft.world.level.gamerules.GameRuleMap;
import net.minecraft.world.level.gamerules.GameRuleType;
import net.minecraft.world.level.gamerules.GameRuleTypeVisitor;
import org.jspecify.annotations.Nullable;

public class GameRules {
    public static final GameRule<Boolean> ADVANCE_TIME = GameRules.registerBoolean("advance_time", GameRuleCategory.UPDATES, !SharedConstants.DEBUG_WORLD_RECREATE);
    public static final GameRule<Boolean> ADVANCE_WEATHER = GameRules.registerBoolean("advance_weather", GameRuleCategory.UPDATES, !SharedConstants.DEBUG_WORLD_RECREATE);
    public static final GameRule<Boolean> ALLOW_ENTERING_NETHER_USING_PORTALS = GameRules.registerBoolean("allow_entering_nether_using_portals", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> BLOCK_DROPS = GameRules.registerBoolean("block_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> BLOCK_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("block_explosion_drop_decay", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> COMMAND_BLOCKS_WORK = GameRules.registerBoolean("command_blocks_work", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> COMMAND_BLOCK_OUTPUT = GameRules.registerBoolean("command_block_output", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> DROWNING_DAMAGE = GameRules.registerBoolean("drowning_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ELYTRA_MOVEMENT_CHECK = GameRules.registerBoolean("elytra_movement_check", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ENDER_PEARLS_VANISH_ON_DEATH = GameRules.registerBoolean("ender_pearls_vanish_on_death", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> ENTITY_DROPS = GameRules.registerBoolean("entity_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> FALL_DAMAGE = GameRules.registerBoolean("fall_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> FIRE_DAMAGE = GameRules.registerBoolean("fire_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Integer> FIRE_SPREAD_RADIUS_AROUND_PLAYER = GameRules.registerInteger("fire_spread_radius_around_player", GameRuleCategory.UPDATES, 128, -1);
    public static final GameRule<Boolean> FORGIVE_DEAD_PLAYERS = GameRules.registerBoolean("forgive_dead_players", GameRuleCategory.MOBS, true);
    public static final GameRule<Boolean> FREEZE_DAMAGE = GameRules.registerBoolean("freeze_damage", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> GLOBAL_SOUND_EVENTS = GameRules.registerBoolean("global_sound_events", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> IMMEDIATE_RESPAWN = GameRules.registerBoolean("immediate_respawn", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> KEEP_INVENTORY = GameRules.registerBoolean("keep_inventory", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> LAVA_SOURCE_CONVERSION = GameRules.registerBoolean("lava_source_conversion", GameRuleCategory.UPDATES, false);
    public static final GameRule<Boolean> LIMITED_CRAFTING = GameRules.registerBoolean("limited_crafting", GameRuleCategory.PLAYER, false);
    public static final GameRule<Boolean> LOCATOR_BAR = GameRules.registerBoolean("locator_bar", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> LOG_ADMIN_COMMANDS = GameRules.registerBoolean("log_admin_commands", GameRuleCategory.CHAT, true);
    public static final GameRule<Integer> MAX_BLOCK_MODIFICATIONS = GameRules.registerInteger("max_block_modifications", GameRuleCategory.MISC, 32768, 1);
    public static final GameRule<Integer> MAX_COMMAND_FORKS = GameRules.registerInteger("max_command_forks", GameRuleCategory.MISC, 65536, 0);
    public static final GameRule<Integer> MAX_COMMAND_SEQUENCE_LENGTH = GameRules.registerInteger("max_command_sequence_length", GameRuleCategory.MISC, 65536, 0);
    public static final GameRule<Integer> MAX_ENTITY_CRAMMING = GameRules.registerInteger("max_entity_cramming", GameRuleCategory.MOBS, 24, 0);
    public static final GameRule<Integer> MAX_MINECART_SPEED = GameRules.registerInteger("max_minecart_speed", GameRuleCategory.MISC, 8, 1, 1000, FeatureFlagSet.of(FeatureFlags.MINECART_IMPROVEMENTS));
    public static final GameRule<Integer> MAX_SNOW_ACCUMULATION_HEIGHT = GameRules.registerInteger("max_snow_accumulation_height", GameRuleCategory.UPDATES, 1, 0, 8);
    public static final GameRule<Boolean> MOB_DROPS = GameRules.registerBoolean("mob_drops", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> MOB_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("mob_explosion_drop_decay", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> MOB_GRIEFING = GameRules.registerBoolean("mob_griefing", GameRuleCategory.MOBS, true);
    public static final GameRule<Boolean> NATURAL_HEALTH_REGENERATION = GameRules.registerBoolean("natural_health_regeneration", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> PLAYER_MOVEMENT_CHECK = GameRules.registerBoolean("player_movement_check", GameRuleCategory.PLAYER, true);
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_CREATIVE_DELAY = GameRules.registerInteger("players_nether_portal_creative_delay", GameRuleCategory.PLAYER, 0, 0);
    public static final GameRule<Integer> PLAYERS_NETHER_PORTAL_DEFAULT_DELAY = GameRules.registerInteger("players_nether_portal_default_delay", GameRuleCategory.PLAYER, 80, 0);
    public static final GameRule<Integer> PLAYERS_SLEEPING_PERCENTAGE = GameRules.registerInteger("players_sleeping_percentage", GameRuleCategory.PLAYER, 100, 0);
    public static final GameRule<Boolean> PROJECTILES_CAN_BREAK_BLOCKS = GameRules.registerBoolean("projectiles_can_break_blocks", GameRuleCategory.DROPS, true);
    public static final GameRule<Boolean> PVP = GameRules.registerBoolean("pvp", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> RAIDS = GameRules.registerBoolean("raids", GameRuleCategory.MOBS, true);
    public static final GameRule<Integer> RANDOM_TICK_SPEED = GameRules.registerInteger("random_tick_speed", GameRuleCategory.UPDATES, 3, 0);
    public static final GameRule<Boolean> REDUCED_DEBUG_INFO = GameRules.registerBoolean("reduced_debug_info", GameRuleCategory.MISC, false);
    public static final GameRule<Integer> RESPAWN_RADIUS = GameRules.registerInteger("respawn_radius", GameRuleCategory.PLAYER, 10, 0);
    public static final GameRule<Boolean> SEND_COMMAND_FEEDBACK = GameRules.registerBoolean("send_command_feedback", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SHOW_ADVANCEMENT_MESSAGES = GameRules.registerBoolean("show_advancement_messages", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SHOW_DEATH_MESSAGES = GameRules.registerBoolean("show_death_messages", GameRuleCategory.CHAT, true);
    public static final GameRule<Boolean> SPAWNER_BLOCKS_WORK = GameRules.registerBoolean("spawner_blocks_work", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> SPAWN_MOBS = GameRules.registerBoolean("spawn_mobs", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_MONSTERS = GameRules.registerBoolean("spawn_monsters", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_PATROLS = GameRules.registerBoolean("spawn_patrols", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_PHANTOMS = GameRules.registerBoolean("spawn_phantoms", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_WANDERING_TRADERS = GameRules.registerBoolean("spawn_wandering_traders", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPAWN_WARDENS = GameRules.registerBoolean("spawn_wardens", GameRuleCategory.SPAWNING, true);
    public static final GameRule<Boolean> SPECTATORS_GENERATE_CHUNKS = GameRules.registerBoolean("spectators_generate_chunks", GameRuleCategory.PLAYER, true);
    public static final GameRule<Boolean> SPREAD_VINES = GameRules.registerBoolean("spread_vines", GameRuleCategory.UPDATES, true);
    public static final GameRule<Boolean> TNT_EXPLODES = GameRules.registerBoolean("tnt_explodes", GameRuleCategory.MISC, true);
    public static final GameRule<Boolean> TNT_EXPLOSION_DROP_DECAY = GameRules.registerBoolean("tnt_explosion_drop_decay", GameRuleCategory.DROPS, false);
    public static final GameRule<Boolean> UNIVERSAL_ANGER = GameRules.registerBoolean("universal_anger", GameRuleCategory.MOBS, false);
    public static final GameRule<Boolean> WATER_SOURCE_CONVERSION = GameRules.registerBoolean("water_source_conversion", GameRuleCategory.UPDATES, true);
    private final GameRuleMap rules;

    public static Codec<GameRules> codec(FeatureFlagSet var02) {
        return GameRuleMap.CODEC.xmap(var1 -> new GameRules(var02, (GameRuleMap)var1), var0 -> var0.rules);
    }

    public GameRules(FeatureFlagSet var0, GameRuleMap var1) {
        this(var0);
        this.rules.setFromIf(var1, this.rules::has);
    }

    public GameRules(FeatureFlagSet var0) {
        this.rules = GameRuleMap.of(BuiltInRegistries.GAME_RULE.filterFeatures(var0).listElements().map(Holder::value));
    }

    public Stream<GameRule<?>> availableRules() {
        return this.rules.keySet().stream();
    }

    public <T> T get(GameRule<T> var0) {
        T var1 = this.rules.get(var0);
        if (var1 == null) {
            throw new IllegalArgumentException("Tried to access invalid game rule");
        }
        return var1;
    }

    public <T> void set(GameRule<T> var0, T var1, @Nullable MinecraftServer var2) {
        if (!this.rules.has(var0)) {
            throw new IllegalArgumentException("Tried to set invalid game rule");
        }
        this.rules.set(var0, var1);
        if (var2 != null) {
            var2.onGameRuleChanged(var0, var1);
        }
    }

    public GameRules copy(FeatureFlagSet var0) {
        return new GameRules(var0, this.rules);
    }

    public void setAll(GameRules var0, @Nullable MinecraftServer var1) {
        this.setAll(var0.rules, var1);
    }

    public void setAll(GameRuleMap var0, @Nullable MinecraftServer var1) {
        var0.keySet().forEach(var2 -> this.setFromOther(var0, (GameRule)var2, var1));
    }

    private <T> void setFromOther(GameRuleMap var0, GameRule<T> var1, @Nullable MinecraftServer var2) {
        this.set(var1, Objects.requireNonNull(var0.get(var1)), var2);
    }

    public void visitGameRuleTypes(GameRuleTypeVisitor var0) {
        this.rules.keySet().forEach(var1 -> {
            var0.visit(var1);
            var1.callVisitor(var0);
        });
    }

    private static GameRule<Boolean> registerBoolean(String var02, GameRuleCategory var1, boolean var2) {
        return GameRules.register(var02, var1, GameRuleType.BOOL, BoolArgumentType.bool(), Codec.BOOL, var2, FeatureFlagSet.of(), GameRuleTypeVisitor::visitBoolean, var0 -> var0 != false ? 1 : 0);
    }

    private static GameRule<Integer> registerInteger(String var0, GameRuleCategory var1, int var2, int var3) {
        return GameRules.registerInteger(var0, var1, var2, var3, Integer.MAX_VALUE, FeatureFlagSet.of());
    }

    private static GameRule<Integer> registerInteger(String var0, GameRuleCategory var1, int var2, int var3, int var4) {
        return GameRules.registerInteger(var0, var1, var2, var3, var4, FeatureFlagSet.of());
    }

    private static GameRule<Integer> registerInteger(String var02, GameRuleCategory var1, int var2, int var3, int var4, FeatureFlagSet var5) {
        return GameRules.register(var02, var1, GameRuleType.INT, IntegerArgumentType.integer((int)var3, (int)var4), Codec.intRange((int)var3, (int)var4), var2, var5, GameRuleTypeVisitor::visitInteger, var0 -> var0);
    }

    private static <T> GameRule<T> register(String var0, GameRuleCategory var1, GameRuleType var2, ArgumentType<T> var3, Codec<T> var4, T var5, FeatureFlagSet var6, a<T> var7, ToIntFunction<T> var8) {
        return IRegistry.register(BuiltInRegistries.GAME_RULE, var0, new GameRule<T>(var1, var2, var3, var7, var4, var8, var5, var6));
    }

    public static GameRule<?> bootstrap(IRegistry<GameRule<?>> var0) {
        return ADVANCE_TIME;
    }

    public <T> String getAsString(GameRule<T> var0) {
        return var0.serialize(this.get(var0));
    }

    public static interface a<T> {
        public void call(GameRuleTypeVisitor var1, GameRule<T> var2);
    }
}

