/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.serialization.Codec;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import org.jspecify.annotations.Nullable;

public interface DensityFunction {
    public static final Codec<DensityFunction> DIRECT_CODEC = DensityFunctions.DIRECT_CODEC;
    public static final Codec<Holder<DensityFunction>> CODEC = RegistryFileCodec.create(Registries.DENSITY_FUNCTION, DIRECT_CODEC);
    public static final Codec<DensityFunction> HOLDER_HELPER_CODEC = CODEC.xmap(DensityFunctions.k::new, var0 -> {
        if (var0 instanceof DensityFunctions.k) {
            DensityFunctions.k var1 = (DensityFunctions.k)var0;
            return var1.function();
        }
        return new Holder.a<DensityFunction>((DensityFunction)var0);
    });

    public double compute(b var1);

    public void fillArray(double[] var1, a var2);

    public DensityFunction mapAll(f var1);

    public double minValue();

    public double maxValue();

    public KeyDispatchDataCodec<? extends DensityFunction> codec();

    default public DensityFunction clamp(double var0, double var2) {
        return new DensityFunctions.g(this, var0, var2);
    }

    default public DensityFunction abs() {
        return DensityFunctions.map(this, DensityFunctions.l.a.ABS);
    }

    default public DensityFunction square() {
        return DensityFunctions.map(this, DensityFunctions.l.a.SQUARE);
    }

    default public DensityFunction cube() {
        return DensityFunctions.map(this, DensityFunctions.l.a.CUBE);
    }

    default public DensityFunction halfNegative() {
        return DensityFunctions.map(this, DensityFunctions.l.a.HALF_NEGATIVE);
    }

    default public DensityFunction quarterNegative() {
        return DensityFunctions.map(this, DensityFunctions.l.a.QUARTER_NEGATIVE);
    }

    default public DensityFunction invert() {
        return DensityFunctions.map(this, DensityFunctions.l.a.INVERT);
    }

    default public DensityFunction squeeze() {
        return DensityFunctions.map(this, DensityFunctions.l.a.SQUEEZE);
    }

    public record e(int blockX, int blockY, int blockZ) implements b
    {
    }

    public static interface b {
        public int blockX();

        public int blockY();

        public int blockZ();

        default public Blender getBlender() {
            return Blender.empty();
        }
    }

    public static interface d
    extends DensityFunction {
        @Override
        default public void fillArray(double[] var0, a var1) {
            var1.fillAllDirectly(var0, this);
        }

        @Override
        default public DensityFunction mapAll(f var0) {
            return var0.apply(this);
        }
    }

    public static interface f {
        public DensityFunction apply(DensityFunction var1);

        default public c visitNoise(c var0) {
            return var0;
        }
    }

    public record c(Holder<NoiseGeneratorNormal.a> noiseData, @Nullable NoiseGeneratorNormal noise) {
        public static final Codec<c> CODEC = NoiseGeneratorNormal.a.CODEC.xmap(var0 -> new c((Holder<NoiseGeneratorNormal.a>)var0, null), c::noiseData);

        public c(Holder<NoiseGeneratorNormal.a> var0) {
            this(var0, null);
        }

        public double getValue(double var0, double var2, double var4) {
            return this.noise == null ? 0.0 : this.noise.getValue(var0, var2, var4);
        }

        public double maxValue() {
            return this.noise == null ? 2.0 : this.noise.maxValue();
        }
    }

    public static interface a {
        public b forIndex(int var1);

        public void fillAllDirectly(double[] var1, DensityFunction var2);
    }
}

