/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.monster.EntityMonsterPatrolling;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.HeightMap;

public class MobSpawnerPatrol
implements MobSpawner {
    private int nextTick;

    @Override
    public void tick(WorldServer var0, boolean var1) {
        if (!var1) {
            return;
        }
        if (!var0.getGameRules().get(GameRules.SPAWN_PATROLS).booleanValue()) {
            return;
        }
        RandomSource var2 = var0.random;
        --this.nextTick;
        if (this.nextTick > 0) {
            return;
        }
        this.nextTick += 12000 + var2.nextInt(1200);
        if (!var0.isBrightOutside()) {
            return;
        }
        if (var2.nextInt(5) != 0) {
            return;
        }
        int var3 = var0.players().size();
        if (var3 < 1) {
            return;
        }
        EntityHuman var4 = var0.players().get(var2.nextInt(var3));
        if (var4.isSpectator()) {
            return;
        }
        if (var0.isCloseToVillage(var4.blockPosition(), 2)) {
            return;
        }
        int var5 = (24 + var2.nextInt(24)) * (var2.nextBoolean() ? -1 : 1);
        int var6 = (24 + var2.nextInt(24)) * (var2.nextBoolean() ? -1 : 1);
        BlockPosition.MutableBlockPosition var7 = var4.blockPosition().mutable().move(var5, 0, var6);
        int var8 = 10;
        if (!var0.hasChunksAt(var7.getX() - 10, var7.getZ() - 10, var7.getX() + 10, var7.getZ() + 10)) {
            return;
        }
        if (!var0.environmentAttributes().getValue(EnvironmentAttributes.CAN_PILLAGER_PATROL_SPAWN, var7).booleanValue()) {
            return;
        }
        int var9 = (int)Math.ceil(var0.getCurrentDifficultyAt(var7).getEffectiveDifficulty()) + 1;
        for (int var10 = 0; var10 < var9; ++var10) {
            var7.setY(var0.getHeightmapPos(HeightMap.Type.MOTION_BLOCKING_NO_LEAVES, var7).getY());
            if (var10 == 0) {
                if (!this.spawnPatrolMember(var0, var7, var2, true)) {
                    break;
                }
            } else {
                this.spawnPatrolMember(var0, var7, var2, false);
            }
            var7.setX(var7.getX() + var2.nextInt(5) - var2.nextInt(5));
            var7.setZ(var7.getZ() + var2.nextInt(5) - var2.nextInt(5));
        }
    }

    private boolean spawnPatrolMember(WorldServer var0, BlockPosition var1, RandomSource var2, boolean var3) {
        IBlockData var4 = var0.getBlockState(var1);
        if (!SpawnerCreature.isValidEmptySpawnBlock(var0, var1, var4, var4.getFluidState(), EntityTypes.PILLAGER)) {
            return false;
        }
        if (!EntityMonsterPatrolling.checkPatrollingMonsterSpawnRules(EntityTypes.PILLAGER, var0, EntitySpawnReason.PATROL, var1, var2)) {
            return false;
        }
        EntityMonsterPatrolling var5 = EntityTypes.PILLAGER.create(var0, EntitySpawnReason.PATROL);
        if (var5 != null) {
            if (var3) {
                var5.setPatrolLeader(true);
                var5.findPatrolTarget();
            }
            var5.setPos(var1.getX(), var1.getY(), var1.getZ());
            var5.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var1), EntitySpawnReason.PATROL, null);
            var0.addFreshEntityWithPassengers(var5);
            return true;
        }
        return false;
    }
}

