/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.serialization.Codec;
import java.util.stream.LongStream;
import net.minecraft.util.SystemUtils;
import net.minecraft.world.level.levelgen.RandomSupport;

public class Xoroshiro128PlusPlus {
    private long seedLo;
    private long seedHi;
    public static final Codec<Xoroshiro128PlusPlus> CODEC = Codec.LONG_STREAM.comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 2).map(var0 -> new Xoroshiro128PlusPlus(var0[0], var0[1])), var0 -> LongStream.of(var0.seedLo, var0.seedHi));

    public Xoroshiro128PlusPlus(RandomSupport.a var0) {
        this(var0.seedLo(), var0.seedHi());
    }

    public Xoroshiro128PlusPlus(long var0, long var2) {
        this.seedLo = var0;
        this.seedHi = var2;
        if ((this.seedLo | this.seedHi) == 0L) {
            this.seedLo = -7046029254386353131L;
            this.seedHi = 7640891576956012809L;
        }
    }

    public long nextLong() {
        long var0 = this.seedLo;
        long var2 = this.seedHi;
        long var4 = Long.rotateLeft(var0 + var2, 17) + var0;
        this.seedLo = Long.rotateLeft(var0, 49) ^ (var2 ^= var0) ^ var2 << 21;
        this.seedHi = Long.rotateLeft(var2, 28);
        return var4;
    }
}

