/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;

public class WorldGenFeatureTreeConfiguration
implements WorldGenFeatureConfiguration {
    public static final Codec<WorldGenFeatureTreeConfiguration> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)WorldGenFeatureStateProvider.CODEC.fieldOf("trunk_provider").forGetter(var0 -> var0.trunkProvider), (App)TrunkPlacer.CODEC.fieldOf("trunk_placer").forGetter(var0 -> var0.trunkPlacer), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("foliage_provider").forGetter(var0 -> var0.foliageProvider), (App)WorldGenFoilagePlacer.CODEC.fieldOf("foliage_placer").forGetter(var0 -> var0.foliagePlacer), (App)RootPlacer.CODEC.optionalFieldOf("root_placer").forGetter(var0 -> var0.rootPlacer), (App)WorldGenFeatureStateProvider.CODEC.fieldOf("dirt_provider").forGetter(var0 -> var0.dirtProvider), (App)FeatureSize.CODEC.fieldOf("minimum_size").forGetter(var0 -> var0.minimumSize), (App)WorldGenFeatureTree.CODEC.listOf().fieldOf("decorators").forGetter(var0 -> var0.decorators), (App)Codec.BOOL.fieldOf("ignore_vines").orElse((Object)false).forGetter(var0 -> var0.ignoreVines), (App)Codec.BOOL.fieldOf("force_dirt").orElse((Object)false).forGetter(var0 -> var0.forceDirt)).apply((Applicative)var02, WorldGenFeatureTreeConfiguration::new));
    public final WorldGenFeatureStateProvider trunkProvider;
    public final WorldGenFeatureStateProvider dirtProvider;
    public final TrunkPlacer trunkPlacer;
    public final WorldGenFeatureStateProvider foliageProvider;
    public final WorldGenFoilagePlacer foliagePlacer;
    public final Optional<RootPlacer> rootPlacer;
    public final FeatureSize minimumSize;
    public final List<WorldGenFeatureTree> decorators;
    public final boolean ignoreVines;
    public final boolean forceDirt;

    protected WorldGenFeatureTreeConfiguration(WorldGenFeatureStateProvider var0, TrunkPlacer var1, WorldGenFeatureStateProvider var2, WorldGenFoilagePlacer var3, Optional<RootPlacer> var4, WorldGenFeatureStateProvider var5, FeatureSize var6, List<WorldGenFeatureTree> var7, boolean var8, boolean var9) {
        this.trunkProvider = var0;
        this.trunkPlacer = var1;
        this.foliageProvider = var2;
        this.foliagePlacer = var3;
        this.rootPlacer = var4;
        this.dirtProvider = var5;
        this.minimumSize = var6;
        this.decorators = var7;
        this.ignoreVines = var8;
        this.forceDirt = var9;
    }

    public static class a {
        public final WorldGenFeatureStateProvider trunkProvider;
        private final TrunkPlacer trunkPlacer;
        public final WorldGenFeatureStateProvider foliageProvider;
        private final WorldGenFoilagePlacer foliagePlacer;
        private final Optional<RootPlacer> rootPlacer;
        private WorldGenFeatureStateProvider dirtProvider;
        private final FeatureSize minimumSize;
        private List<WorldGenFeatureTree> decorators = ImmutableList.of();
        private boolean ignoreVines;
        private boolean forceDirt;

        public a(WorldGenFeatureStateProvider var0, TrunkPlacer var1, WorldGenFeatureStateProvider var2, WorldGenFoilagePlacer var3, Optional<RootPlacer> var4, FeatureSize var5) {
            this.trunkProvider = var0;
            this.trunkPlacer = var1;
            this.foliageProvider = var2;
            this.dirtProvider = WorldGenFeatureStateProvider.simple(Blocks.DIRT);
            this.foliagePlacer = var3;
            this.rootPlacer = var4;
            this.minimumSize = var5;
        }

        public a(WorldGenFeatureStateProvider var0, TrunkPlacer var1, WorldGenFeatureStateProvider var2, WorldGenFoilagePlacer var3, FeatureSize var4) {
            this(var0, var1, var2, var3, Optional.empty(), var4);
        }

        public a dirt(WorldGenFeatureStateProvider var0) {
            this.dirtProvider = var0;
            return this;
        }

        public a decorators(List<WorldGenFeatureTree> var0) {
            this.decorators = var0;
            return this;
        }

        public a ignoreVines() {
            this.ignoreVines = true;
            return this;
        }

        public a forceDirt() {
            this.forceDirt = true;
            return this;
        }

        public WorldGenFeatureTreeConfiguration build() {
            return new WorldGenFeatureTreeConfiguration(this.trunkProvider, this.trunkPlacer, this.foliageProvider, this.foliagePlacer, this.rootPlacer, this.dirtProvider, this.minimumSize, this.decorators, this.ignoreVines, this.forceDirt);
        }
    }
}

