/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.stateproviders;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.feature.stateproviders.NoiseProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProviders;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public class DualNoiseProvider
extends NoiseProvider {
    public static final MapCodec<DualNoiseProvider> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)InclusiveRange.codec(Codec.INT, 1, 64).fieldOf("variety").forGetter(var0 -> var0.variety), (App)NoiseGeneratorNormal.a.DIRECT_CODEC.fieldOf("slow_noise").forGetter(var0 -> var0.slowNoiseParameters), (App)ExtraCodecs.POSITIVE_FLOAT.fieldOf("slow_scale").forGetter(var0 -> Float.valueOf(var0.slowScale))).and(DualNoiseProvider.noiseProviderCodec(var02)).apply((Applicative)var02, DualNoiseProvider::new));
    private final InclusiveRange<Integer> variety;
    private final NoiseGeneratorNormal.a slowNoiseParameters;
    private final float slowScale;
    private final NoiseGeneratorNormal slowNoise;

    public DualNoiseProvider(InclusiveRange<Integer> var0, NoiseGeneratorNormal.a var1, float var2, long var3, NoiseGeneratorNormal.a var5, float var6, List<IBlockData> var7) {
        super(var3, var5, var6, var7);
        this.variety = var0;
        this.slowNoiseParameters = var1;
        this.slowScale = var2;
        this.slowNoise = NoiseGeneratorNormal.create(new SeededRandom(new LegacyRandomSource(var3)), var1);
    }

    @Override
    protected WorldGenFeatureStateProviders<?> type() {
        return WorldGenFeatureStateProviders.DUAL_NOISE_PROVIDER;
    }

    @Override
    public IBlockData getState(RandomSource var0, BlockPosition var1) {
        double var2 = this.getSlowNoiseValue(var1);
        int var4 = (int)MathHelper.clampedMap(var2, -1.0, 1.0, (double)this.variety.minInclusive().intValue(), (double)(this.variety.maxInclusive() + 1));
        ArrayList var5 = Lists.newArrayListWithCapacity((int)var4);
        for (int var6 = 0; var6 < var4; ++var6) {
            var5.add(this.getRandomState(this.states, this.getSlowNoiseValue(var1.offset(var6 * 54545, 0, var6 * 34234))));
        }
        return this.getRandomState(var5, var1, this.scale);
    }

    protected double getSlowNoiseValue(BlockPosition var0) {
        return this.slowNoise.getValue((float)var0.getX() * this.slowScale, (float)var0.getY() * this.slowScale, (float)var0.getZ() * this.slowScale);
    }
}

