/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.BlockFence;
import net.minecraft.world.level.block.BlockStairs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityMobSpawner;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.storage.loot.LootTables;
import org.jspecify.annotations.Nullable;

public class NetherFortressPieces {
    private static final int MAX_DEPTH = 30;
    private static final int LOWEST_Y_POSITION = 10;
    public static final int MAGIC_START_Y = 64;
    static final n[] BRIDGE_PIECE_WEIGHTS = new n[]{new n(c.class, 30, 0, true), new n(a.class, 10, 4), new n(o.class, 10, 4), new n(p.class, 10, 3), new n(l.class, 5, 2), new n(f.class, 5, 1)};
    static final n[] CASTLE_PIECE_WEIGHTS = new n[]{new n(i.class, 25, 0, true), new n(g.class, 15, 5), new n(j.class, 5, 10), new n(h.class, 5, 10), new n(d.class, 10, 3, true), new n(e.class, 7, 2), new n(k.class, 5, 2)};

    static @Nullable m findAndCreateBridgePieceFactory(n var0, StructurePieceAccessor var1, RandomSource var2, int var3, int var4, int var5, EnumDirection var6, int var7) {
        Class<? extends m> var8 = var0.pieceClass;
        m var9 = null;
        if (var8 == c.class) {
            var9 = c.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var8 == a.class) {
            var9 = a.createPiece(var1, var3, var4, var5, var6, var7);
        } else if (var8 == o.class) {
            var9 = o.createPiece(var1, var3, var4, var5, var6, var7);
        } else if (var8 == p.class) {
            var9 = p.createPiece(var1, var3, var4, var5, var7, var6);
        } else if (var8 == l.class) {
            var9 = l.createPiece(var1, var3, var4, var5, var7, var6);
        } else if (var8 == f.class) {
            var9 = f.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var8 == i.class) {
            var9 = i.createPiece(var1, var3, var4, var5, var6, var7);
        } else if (var8 == j.class) {
            var9 = j.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var8 == h.class) {
            var9 = h.createPiece(var1, var2, var3, var4, var5, var6, var7);
        } else if (var8 == d.class) {
            var9 = d.createPiece(var1, var3, var4, var5, var6, var7);
        } else if (var8 == e.class) {
            var9 = e.createPiece(var1, var3, var4, var5, var6, var7);
        } else if (var8 == g.class) {
            var9 = g.createPiece(var1, var3, var4, var5, var6, var7);
        } else if (var8 == k.class) {
            var9 = k.createPiece(var1, var3, var4, var5, var6, var7);
        }
        return var9;
    }

    static class n {
        public final Class<? extends m> pieceClass;
        public final int weight;
        public int placeCount;
        public final int maxPlaceCount;
        public final boolean allowInRow;

        public n(Class<? extends m> var0, int var1, int var2, boolean var3) {
            this.pieceClass = var0;
            this.weight = var1;
            this.maxPlaceCount = var2;
            this.allowInRow = var3;
        }

        public n(Class<? extends m> var0, int var1, int var2) {
            this(var0, var1, var2, false);
        }

        public boolean doPlace(int var0) {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }

        public boolean isValid() {
            return this.maxPlaceCount == 0 || this.placeCount < this.maxPlaceCount;
        }
    }

    public static class c
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public c(int var0, RandomSource var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, var0, var2);
            this.setOrientation(var3);
        }

        public c(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_STRAIGHT, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 1, 3, false);
        }

        public static @Nullable c createPiece(StructurePieceAccessor var0, RandomSource var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -3, 0, 5, 10, 19, var5);
            if (!c.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new c(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 3, 0, 4, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 5, 0, 3, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 0, 0, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 5, 0, 4, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 4, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 13, 4, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 0, 0, 4, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 0, 15, 4, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int var7 = 0; var7 <= 4; ++var7) {
                for (int var8 = 0; var8 <= 2; ++var8) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var7, -1, var8, var4);
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var7, -1, 18 - var8, var4);
                }
            }
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            IBlockData var8 = (IBlockData)var7.setValue(BlockFence.EAST, true);
            IBlockData var9 = (IBlockData)var7.setValue(BlockFence.WEST, true);
            this.generateBox(var0, var4, 0, 1, 1, 0, 4, 1, var8, var8, false);
            this.generateBox(var0, var4, 0, 3, 4, 0, 4, 4, var8, var8, false);
            this.generateBox(var0, var4, 0, 3, 14, 0, 4, 14, var8, var8, false);
            this.generateBox(var0, var4, 0, 1, 17, 0, 4, 17, var8, var8, false);
            this.generateBox(var0, var4, 4, 1, 1, 4, 4, 1, var9, var9, false);
            this.generateBox(var0, var4, 4, 3, 4, 4, 4, 4, var9, var9, false);
            this.generateBox(var0, var4, 4, 3, 14, 4, 4, 14, var9, var9, false);
            this.generateBox(var0, var4, 4, 1, 17, 4, 4, 17, var9, var9, false);
        }
    }

    public static class a
    extends m {
        private static final int WIDTH = 19;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 19;

        public a(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, var0, var1);
            this.setOrientation(var2);
        }

        protected a(int var0, int var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, 0, StructurePiece.makeBoundingBox(var0, 64, var1, var2, 19, 10, 19));
            this.setOrientation(var2);
        }

        protected a(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
            super(var0, var1);
        }

        public a(NBTTagCompound var0) {
            this(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_CROSSING, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 8, 3, false);
            this.generateChildLeft((q)var0, var1, var2, 3, 8, false);
            this.generateChildRight((q)var0, var1, var2, 3, 8, false);
        }

        public static @Nullable a createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -8, -3, 0, 19, 10, 19, var4);
            if (!a.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new a(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var8;
            int var7;
            this.generateBox(var0, var4, 7, 3, 0, 11, 4, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 3, 7, 18, 4, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 5, 0, 10, 7, 18, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 8, 18, 7, 10, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 7, 5, 0, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 7, 5, 11, 7, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 11, 5, 0, 11, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 11, 5, 11, 11, 5, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 7, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 11, 5, 7, 18, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 11, 7, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 11, 5, 11, 18, 5, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 7, 2, 0, 11, 2, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 7, 2, 13, 11, 2, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 7, 0, 0, 11, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 7, 0, 15, 11, 1, 18, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (var7 = 7; var7 <= 11; ++var7) {
                for (var8 = 0; var8 <= 2; ++var8) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var7, -1, var8, var4);
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var7, -1, 18 - var8, var4);
                }
            }
            this.generateBox(var0, var4, 0, 2, 7, 5, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 13, 2, 7, 18, 2, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 0, 7, 3, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 15, 0, 7, 18, 1, 11, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (var7 = 0; var7 <= 2; ++var7) {
                for (var8 = 7; var8 <= 11; ++var8) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var7, -1, var8, var4);
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 18 - var7, -1, var8, var4);
                }
            }
        }
    }

    public static class o
    extends m {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 9;
        private static final int DEPTH = 7;

        public o(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, var0, var1);
            this.setOrientation(var2);
        }

        public o(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_ROOM_CROSSING, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 2, 0, false);
            this.generateChildLeft((q)var0, var1, var2, 0, 2, false);
            this.generateChildRight((q)var0, var1, var2, 0, 2, false);
        }

        public static @Nullable o createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -2, 0, 0, 7, 9, 7, var4);
            if (!o.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new o(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 6, 7, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 1, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 6, 1, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 2, 0, 6, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 2, 6, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 0, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 5, 0, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 2, 0, 6, 6, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 2, 5, 6, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(var0, var4, 2, 6, 0, 4, 6, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 0, 4, 5, 0, var7, var7, false);
            this.generateBox(var0, var4, 2, 6, 6, 4, 6, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 6, 4, 5, 6, var7, var7, false);
            this.generateBox(var0, var4, 0, 6, 2, 0, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 2, 0, 5, 4, var8, var8, false);
            this.generateBox(var0, var4, 6, 6, 2, 6, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 5, 2, 6, 5, 4, var8, var8, false);
            for (int var9 = 0; var9 <= 6; ++var9) {
                for (int var10 = 0; var10 <= 6; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, -1, var10, var4);
                }
            }
        }
    }

    public static class p
    extends m {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 11;
        private static final int DEPTH = 7;

        public p(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, var0, var1);
            this.setOrientation(var2);
        }

        public p(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_STAIRS_ROOM, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildRight((q)var0, var1, var2, 6, 2, false);
        }

        public static @Nullable p createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, int var4, EnumDirection var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -2, 0, 0, 7, 11, 7, var5);
            if (!p.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new p(var4, var6, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 6, 1, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 6, 10, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 1, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 2, 0, 6, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 1, 0, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 2, 1, 6, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 2, 6, 5, 8, 6, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(var0, var4, 0, 3, 2, 0, 5, 4, var8, var8, false);
            this.generateBox(var0, var4, 6, 3, 2, 6, 5, 2, var8, var8, false);
            this.generateBox(var0, var4, 6, 3, 4, 6, 5, 4, var8, var8, false);
            this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 5, 2, 5, var4);
            this.generateBox(var0, var4, 4, 2, 5, 4, 3, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 3, 2, 5, 3, 4, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 2, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 2, 5, 1, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 7, 1, 5, 7, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 8, 2, 6, 8, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 6, 0, 4, 8, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 0, 4, 5, 0, var7, var7, false);
            for (int var9 = 0; var9 <= 6; ++var9) {
                for (int var10 = 0; var10 <= 6; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, -1, var10, var4);
                }
            }
        }
    }

    public static class l
    extends m {
        private static final int WIDTH = 7;
        private static final int HEIGHT = 8;
        private static final int DEPTH = 9;
        private boolean hasPlacedSpawner;

        public l(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, var0, var1);
            this.setOrientation(var2);
        }

        public l(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_MONSTER_THRONE, var0);
            this.hasPlacedSpawner = var0.getBooleanOr("Mob", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Mob", this.hasPlacedSpawner);
        }

        public static @Nullable l createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, int var4, EnumDirection var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -2, 0, 0, 7, 8, 9, var5);
            if (!l.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new l(var4, var6, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            BlockPosition.MutableBlockPosition var9;
            this.generateBox(var0, var4, 0, 2, 0, 6, 7, 7, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 0, 0, 5, 1, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 2, 1, 5, 2, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 3, 2, 5, 3, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 4, 3, 5, 4, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 2, 0, 1, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 2, 0, 5, 4, 2, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 5, 2, 1, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 5, 2, 5, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 3, 0, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 5, 3, 6, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 5, 8, 5, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.placeBlock(var0, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true), 1, 6, 3, var4);
            this.placeBlock(var0, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true), 5, 6, 3, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true)).setValue(BlockFence.NORTH, true), 0, 6, 3, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.NORTH, true), 6, 6, 3, var4);
            this.generateBox(var0, var4, 0, 6, 4, 0, 6, 7, var8, var8, false);
            this.generateBox(var0, var4, 6, 6, 4, 6, 6, 7, var8, var8, false);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true)).setValue(BlockFence.SOUTH, true), 0, 6, 8, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.SOUTH, true), 6, 6, 8, var4);
            this.generateBox(var0, var4, 1, 6, 8, 5, 6, 8, var7, var7, false);
            this.placeBlock(var0, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true), 1, 7, 8, var4);
            this.generateBox(var0, var4, 2, 7, 8, 4, 7, 8, var7, var7, false);
            this.placeBlock(var0, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true), 5, 7, 8, var4);
            this.placeBlock(var0, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true), 2, 8, 8, var4);
            this.placeBlock(var0, var7, 3, 8, 8, var4);
            this.placeBlock(var0, (IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true), 4, 8, 8, var4);
            if (!this.hasPlacedSpawner && var4.isInside(var9 = this.getWorldPos(3, 5, 5))) {
                this.hasPlacedSpawner = true;
                var0.setBlock(var9, Blocks.SPAWNER.defaultBlockState(), 2);
                TileEntity var10 = var0.getBlockEntity(var9);
                if (var10 instanceof TileEntityMobSpawner) {
                    TileEntityMobSpawner var11 = (TileEntityMobSpawner)var10;
                    var11.setEntityId(EntityTypes.BLAZE, var3);
                }
            }
            for (int var92 = 0; var92 <= 6; ++var92) {
                for (int var10 = 0; var10 <= 6; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var92, -1, var10, var4);
                }
            }
        }
    }

    public static class f
    extends m {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public f(int var0, RandomSource var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, var0, var2);
            this.setOrientation(var3);
        }

        public f(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_ENTRANCE, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 5, 3, true);
        }

        public static @Nullable f createPiece(StructurePieceAccessor var0, RandomSource var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -5, -3, 0, 13, 14, 13, var5);
            if (!f.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new f(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var10;
            int var9;
            this.generateBox(var0, var4, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 8, 0, 7, 8, 0, Blocks.NETHER_BRICK_FENCE.defaultBlockState(), Blocks.NETHER_BRICK_FENCE.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            for (var9 = 1; var9 <= 11; var9 += 2) {
                this.generateBox(var0, var4, var9, 10, 0, var9, 11, 0, var7, var7, false);
                this.generateBox(var0, var4, var9, 10, 12, var9, 11, 12, var7, var7, false);
                this.generateBox(var0, var4, 0, 10, var9, 0, 11, var9, var8, var8, false);
                this.generateBox(var0, var4, 12, 10, var9, 12, 11, var9, var8, var8, false);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, 13, 0, var4);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, 13, 12, var4);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, var9, var4);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, var9, var4);
                if (var9 == 11) continue;
                this.placeBlock(var0, var7, var9 + 1, 13, 0, var4);
                this.placeBlock(var0, var7, var9 + 1, 13, 12, var4);
                this.placeBlock(var0, var8, 0, 13, var9 + 1, var4);
                this.placeBlock(var0, var8, 12, 13, var9 + 1, var4);
            }
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 0, 13, 0, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.EAST, true), 0, 13, 12, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.WEST, true), 12, 13, 12, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.WEST, true), 12, 13, 0, var4);
            for (var9 = 3; var9 <= 9; var9 += 2) {
                this.generateBox(var0, var4, 1, 7, var9, 1, 8, var9, (IBlockData)var8.setValue(BlockFence.WEST, true), (IBlockData)var8.setValue(BlockFence.WEST, true), false);
                this.generateBox(var0, var4, 11, 7, var9, 11, 8, var9, (IBlockData)var8.setValue(BlockFence.EAST, true), (IBlockData)var8.setValue(BlockFence.EAST, true), false);
            }
            this.generateBox(var0, var4, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (var9 = 4; var9 <= 8; ++var9) {
                for (var10 = 0; var10 <= 2; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, -1, var10, var4);
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, -1, 12 - var10, var4);
                }
            }
            for (var9 = 0; var9 <= 2; ++var9) {
                for (var10 = 4; var10 <= 8; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, -1, var10, var4);
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - var9, -1, var10, var4);
                }
            }
            this.generateBox(var0, var4, 5, 5, 5, 7, 5, 7, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 1, 6, 6, 4, 6, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 6, 0, 6, var4);
            this.placeBlock(var0, Blocks.LAVA.defaultBlockState(), 6, 5, 6, var4);
            BlockPosition.MutableBlockPosition var92 = this.getWorldPos(6, 5, 6);
            if (var4.isInside(var92)) {
                var0.scheduleTick((BlockPosition)var92, FluidTypes.LAVA, 0);
            }
        }
    }

    public static class i
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public i(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, var0, var1);
            this.setOrientation(var2);
        }

        public i(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 1, 0, true);
        }

        public static @Nullable i createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -1, 0, 0, 5, 7, 5, var4);
            if (!i.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new i(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(var0, var4, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 3, 1, 0, 4, 1, var7, var7, false);
            this.generateBox(var0, var4, 0, 3, 3, 0, 4, 3, var7, var7, false);
            this.generateBox(var0, var4, 4, 3, 1, 4, 4, 1, var7, var7, false);
            this.generateBox(var0, var4, 4, 3, 3, 4, 4, 3, var7, var7, false);
            this.generateBox(var0, var4, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int var8 = 0; var8 <= 4; ++var8) {
                for (int var9 = 0; var9 <= 4; ++var9) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var8, -1, var9, var4);
                }
            }
        }
    }

    public static class j
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public j(int var0, RandomSource var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, var0, var2);
            this.setOrientation(var3);
            this.isNeedingChest = var1.nextInt(3) == 0;
        }

        public j(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_RIGHT_TURN, var0);
            this.isNeedingChest = var0.getBooleanOr("Chest", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildRight((q)var0, var1, var2, 0, 1, true);
        }

        public static @Nullable j createPiece(StructurePieceAccessor var0, RandomSource var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, 0, 0, 5, 7, 5, var5);
            if (!j.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new j(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(var0, var4, 0, 2, 0, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 3, 1, 0, 4, 1, var8, var8, false);
            this.generateBox(var0, var4, 0, 3, 3, 0, 4, 3, var8, var8, false);
            this.generateBox(var0, var4, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 3, 4, 1, 4, 4, var7, var7, false);
            this.generateBox(var0, var4, 3, 3, 4, 3, 4, 4, var7, var7, false);
            if (this.isNeedingChest && var4.isInside(this.getWorldPos(1, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(var0, var4, var3, 1, 2, 3, LootTables.NETHER_BRIDGE);
            }
            this.generateBox(var0, var4, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int var9 = 0; var9 <= 4; ++var9) {
                for (int var10 = 0; var10 <= 4; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, -1, var10, var4);
                }
            }
        }
    }

    public static class h
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;
        private boolean isNeedingChest;

        public h(int var0, RandomSource var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, var0, var2);
            this.setOrientation(var3);
            this.isNeedingChest = var1.nextInt(3) == 0;
        }

        public h(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_LEFT_TURN, var0);
            this.isNeedingChest = var0.getBooleanOr("Chest", false);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putBoolean("Chest", this.isNeedingChest);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildLeft((q)var0, var1, var2, 0, 1, true);
        }

        public static @Nullable h createPiece(StructurePieceAccessor var0, RandomSource var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, 0, 0, 5, 7, 5, var5);
            if (!h.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new h(var6, var1, var7, var5);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            this.generateBox(var0, var4, 4, 2, 0, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 3, 1, 4, 4, 1, var8, var8, false);
            this.generateBox(var0, var4, 4, 3, 3, 4, 4, 3, var8, var8, false);
            this.generateBox(var0, var4, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 4, 3, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 3, 4, 1, 4, 4, var7, var7, false);
            this.generateBox(var0, var4, 3, 3, 4, 3, 4, 4, var7, var7, false);
            if (this.isNeedingChest && var4.isInside(this.getWorldPos(3, 2, 3))) {
                this.isNeedingChest = false;
                this.createChest(var0, var4, var3, 3, 2, 3, LootTables.NETHER_BRIDGE);
            }
            this.generateBox(var0, var4, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int var9 = 0; var9 <= 4; ++var9) {
                for (int var10 = 0; var10 <= 4; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var9, -1, var10, var4);
                }
            }
        }
    }

    public static class d
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 10;

        public d(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, var0, var1);
            this.setOrientation(var2);
        }

        public d(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_STAIRS, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 1, 0, true);
        }

        public static @Nullable d createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -1, -7, 0, 5, 14, 10, var4);
            if (!d.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new d(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            IBlockData var7 = (IBlockData)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.SOUTH);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            for (int var9 = 0; var9 <= 9; ++var9) {
                int var10 = Math.max(1, 7 - var9);
                int var11 = Math.min(Math.max(var10 + 5, 14 - var9), 13);
                int var12 = var9;
                this.generateBox(var0, var4, 0, 0, var12, 4, var10, var12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(var0, var4, 1, var10 + 1, var12, 3, var11 - 1, var12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
                if (var9 <= 6) {
                    this.placeBlock(var0, var7, 1, var10 + 1, var12, var4);
                    this.placeBlock(var0, var7, 2, var10 + 1, var12, var4);
                    this.placeBlock(var0, var7, 3, var10 + 1, var12, var4);
                }
                this.generateBox(var0, var4, 0, var11, var12, 4, var11, var12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(var0, var4, 0, var10 + 1, var12, 0, var11 - 1, var12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                this.generateBox(var0, var4, 4, var10 + 1, var12, 4, var11 - 1, var12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                if ((var9 & 1) == 0) {
                    this.generateBox(var0, var4, 0, var10 + 2, var12, 0, var10 + 3, var12, var8, var8, false);
                    this.generateBox(var0, var4, 4, var10 + 2, var12, 4, var10 + 3, var12, var8, var8, false);
                }
                for (int var13 = 0; var13 <= 4; ++var13) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var13, -1, var12, var4);
                }
            }
        }
    }

    public static class e
    extends m {
        private static final int WIDTH = 9;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 9;

        public e(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, var0, var1);
            this.setOrientation(var2);
        }

        public e(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_CORRIDOR_T_BALCONY, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            int var3 = 1;
            EnumDirection var4 = this.getOrientation();
            if (var4 == EnumDirection.WEST || var4 == EnumDirection.NORTH) {
                var3 = 5;
            }
            this.generateChildLeft((q)var0, var1, var2, 0, var3, var2.nextInt(8) > 0);
            this.generateChildRight((q)var0, var1, var2, 0, var3, var2.nextInt(8) > 0);
        }

        public static @Nullable e createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -3, 0, 0, 9, 7, 9, var4);
            if (!e.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new e(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            this.generateBox(var0, var4, 0, 0, 0, 8, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 8, 5, 8, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 6, 0, 8, 6, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 2, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 2, 0, 8, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 3, 0, 1, 4, 0, var8, var8, false);
            this.generateBox(var0, var4, 7, 3, 0, 7, 4, 0, var8, var8, false);
            this.generateBox(var0, var4, 0, 2, 4, 8, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 1, 4, 2, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 1, 4, 7, 2, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 3, 8, 7, 3, 8, var8, var8, false);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.EAST, true)).setValue(BlockFence.SOUTH, true), 0, 3, 8, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.SOUTH, true), 8, 3, 8, var4);
            this.generateBox(var0, var4, 0, 3, 6, 0, 3, 7, var7, var7, false);
            this.generateBox(var0, var4, 8, 3, 6, 8, 3, 7, var7, var7, false);
            this.generateBox(var0, var4, 0, 3, 4, 0, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 3, 4, 8, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 3, 5, 2, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 6, 3, 5, 7, 5, 5, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 1, 4, 5, 1, 5, 5, var8, var8, false);
            this.generateBox(var0, var4, 7, 4, 5, 7, 5, 5, var8, var8, false);
            for (int var9 = 0; var9 <= 5; ++var9) {
                for (int var10 = 0; var10 <= 8; ++var10) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var10, -1, var9, var4);
                }
            }
        }
    }

    public static class g
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 7;
        private static final int DEPTH = 5;

        public g(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, var0, var1);
            this.setOrientation(var2);
        }

        public g(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_SMALL_CORRIDOR_CROSSING, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 1, 0, true);
            this.generateChildLeft((q)var0, var1, var2, 0, 1, true);
            this.generateChildRight((q)var0, var1, var2, 0, 1, true);
        }

        public static @Nullable g createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -1, 0, 0, 5, 7, 5, var4);
            if (!g.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new g(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            this.generateBox(var0, var4, 0, 0, 0, 4, 1, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 4, 5, 4, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 0, 0, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 2, 0, 4, 5, 0, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 4, 0, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 2, 4, 4, 5, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 6, 0, 4, 6, 4, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (int var7 = 0; var7 <= 4; ++var7) {
                for (int var8 = 0; var8 <= 4; ++var8) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var7, -1, var8, var4);
                }
            }
        }
    }

    public static class k
    extends m {
        private static final int WIDTH = 13;
        private static final int HEIGHT = 14;
        private static final int DEPTH = 13;

        public k(int var0, StructureBoundingBox var1, EnumDirection var2) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, var0, var1);
            this.setOrientation(var2);
        }

        public k(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_CASTLE_STALK_ROOM, var0);
        }

        @Override
        public void addChildren(StructurePiece var0, StructurePieceAccessor var1, RandomSource var2) {
            this.generateChildForward((q)var0, var1, var2, 5, 3, true);
            this.generateChildForward((q)var0, var1, var2, 5, 11, true);
        }

        public static @Nullable k createPiece(StructurePieceAccessor var0, int var1, int var2, int var3, EnumDirection var4, int var5) {
            StructureBoundingBox var6 = StructureBoundingBox.orientBox(var1, var2, var3, -5, -3, 0, 13, 14, 13, var4);
            if (!k.isOkBox(var6) || var0.findCollisionPiece(var6) != null) {
                return null;
            }
            return new k(var5, var6, var4);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var15;
            int var14;
            int var12;
            int var11;
            this.generateBox(var0, var4, 0, 3, 0, 12, 4, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 0, 12, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 5, 0, 1, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 11, 5, 0, 12, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 11, 4, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 5, 11, 10, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 9, 11, 7, 12, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 0, 4, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 5, 0, 10, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 5, 9, 0, 7, 12, 1, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 11, 2, 10, 12, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData var7 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.WEST, true)).setValue(BlockFence.EAST, true);
            IBlockData var8 = (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.SOUTH, true);
            IBlockData var9 = (IBlockData)var8.setValue(BlockFence.WEST, true);
            IBlockData var10 = (IBlockData)var8.setValue(BlockFence.EAST, true);
            for (var11 = 1; var11 <= 11; var11 += 2) {
                this.generateBox(var0, var4, var11, 10, 0, var11, 11, 0, var7, var7, false);
                this.generateBox(var0, var4, var11, 10, 12, var11, 11, 12, var7, var7, false);
                this.generateBox(var0, var4, 0, 10, var11, 0, 11, var11, var8, var8, false);
                this.generateBox(var0, var4, 12, 10, var11, 12, 11, var11, var8, var8, false);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var11, 13, 0, var4);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var11, 13, 12, var4);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 0, 13, var11, var4);
                this.placeBlock(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 12, 13, var11, var4);
                if (var11 == 11) continue;
                this.placeBlock(var0, var7, var11 + 1, 13, 0, var4);
                this.placeBlock(var0, var7, var11 + 1, 13, 12, var4);
                this.placeBlock(var0, var8, 0, 13, var11 + 1, var4);
                this.placeBlock(var0, var8, 12, 13, var11 + 1, var4);
            }
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.EAST, true), 0, 13, 0, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.EAST, true), 0, 13, 12, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.SOUTH, true)).setValue(BlockFence.WEST, true), 12, 13, 12, var4);
            this.placeBlock(var0, (IBlockData)((IBlockData)Blocks.NETHER_BRICK_FENCE.defaultBlockState().setValue(BlockFence.NORTH, true)).setValue(BlockFence.WEST, true), 12, 13, 0, var4);
            for (var11 = 3; var11 <= 9; var11 += 2) {
                this.generateBox(var0, var4, 1, 7, var11, 1, 8, var11, var9, var9, false);
                this.generateBox(var0, var4, 11, 7, var11, 11, 8, var11, var10, var10, false);
            }
            IBlockData var112 = (IBlockData)Blocks.NETHER_BRICK_STAIRS.defaultBlockState().setValue(BlockStairs.FACING, EnumDirection.NORTH);
            for (var12 = 0; var12 <= 6; ++var12) {
                int var13 = var12 + 4;
                for (var14 = 5; var14 <= 7; ++var14) {
                    this.placeBlock(var0, var112, var14, 5 + var12, var13, var4);
                }
                if (var13 >= 5 && var13 <= 8) {
                    this.generateBox(var0, var4, 5, 5, var13, 7, var12 + 4, var13, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                } else if (var13 >= 9 && var13 <= 10) {
                    this.generateBox(var0, var4, 5, 8, var13, 7, var12 + 4, var13, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
                if (var12 < 1) continue;
                this.generateBox(var0, var4, 5, 6 + var12, var13, 7, 9 + var12, var13, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            }
            for (var12 = 5; var12 <= 7; ++var12) {
                this.placeBlock(var0, var112, var12, 12, 11, var4);
            }
            this.generateBox(var0, var4, 5, 6, 7, 5, 7, 7, var10, var10, false);
            this.generateBox(var0, var4, 7, 6, 7, 7, 7, 7, var9, var9, false);
            this.generateBox(var0, var4, 5, 13, 12, 7, 13, 12, Blocks.AIR.defaultBlockState(), Blocks.AIR.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 2, 3, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 9, 3, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 2, 5, 4, 2, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 9, 5, 2, 10, 5, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 9, 5, 9, 10, 5, 10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 10, 5, 4, 10, 5, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            IBlockData var122 = (IBlockData)var112.setValue(BlockStairs.FACING, EnumDirection.EAST);
            IBlockData var13 = (IBlockData)var112.setValue(BlockStairs.FACING, EnumDirection.WEST);
            this.placeBlock(var0, var13, 4, 5, 2, var4);
            this.placeBlock(var0, var13, 4, 5, 3, var4);
            this.placeBlock(var0, var13, 4, 5, 9, var4);
            this.placeBlock(var0, var13, 4, 5, 10, var4);
            this.placeBlock(var0, var122, 8, 5, 2, var4);
            this.placeBlock(var0, var122, 8, 5, 3, var4);
            this.placeBlock(var0, var122, 8, 5, 9, var4);
            this.placeBlock(var0, var122, 8, 5, 10, var4);
            this.generateBox(var0, var4, 3, 4, 4, 4, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 4, 4, 9, 4, 8, Blocks.SOUL_SAND.defaultBlockState(), Blocks.SOUL_SAND.defaultBlockState(), false);
            this.generateBox(var0, var4, 3, 5, 4, 4, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(var0, var4, 8, 5, 4, 9, 5, 8, Blocks.NETHER_WART.defaultBlockState(), Blocks.NETHER_WART.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 2, 0, 8, 2, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 2, 4, 12, 2, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 0, 0, 8, 1, 3, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 4, 0, 9, 8, 1, 12, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 0, 0, 4, 3, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            this.generateBox(var0, var4, 9, 0, 4, 12, 1, 8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (var14 = 4; var14 <= 8; ++var14) {
                for (var15 = 0; var15 <= 2; ++var15) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var14, -1, var15, var4);
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var14, -1, 12 - var15, var4);
                }
            }
            for (var14 = 0; var14 <= 2; ++var14) {
                for (var15 = 4; var15 <= 8; ++var15) {
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), var14, -1, var15, var4);
                    this.fillColumnDown(var0, Blocks.NETHER_BRICKS.defaultBlockState(), 12 - var14, -1, var15, var4);
                }
            }
        }
    }

    public static class b
    extends m {
        private static final int WIDTH = 5;
        private static final int HEIGHT = 10;
        private static final int DEPTH = 8;
        private final int selfSeed;

        public b(int var0, RandomSource var1, StructureBoundingBox var2, EnumDirection var3) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, var0, var2);
            this.setOrientation(var3);
            this.selfSeed = var1.nextInt();
        }

        public b(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_BRIDGE_END_FILLER, var0);
            this.selfSeed = var0.getIntOr("Seed", 0);
        }

        public static @Nullable b createPiece(StructurePieceAccessor var0, RandomSource var1, int var2, int var3, int var4, EnumDirection var5, int var6) {
            StructureBoundingBox var7 = StructureBoundingBox.orientBox(var2, var3, var4, -1, -3, 0, 5, 10, 8, var5);
            if (!b.isOkBox(var7) || var0.findCollisionPiece(var7) != null) {
                return null;
            }
            return new b(var6, var1, var7, var5);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
            super.addAdditionalSaveData(var0, var1);
            var1.putInt("Seed", this.selfSeed);
        }

        @Override
        public void postProcess(GeneratorAccessSeed var0, StructureManager var1, ChunkGenerator var2, RandomSource var3, StructureBoundingBox var4, ChunkCoordIntPair var5, BlockPosition var6) {
            int var10;
            int var9;
            int var8;
            RandomSource var7 = RandomSource.create(this.selfSeed);
            for (var8 = 0; var8 <= 4; ++var8) {
                for (var9 = 3; var9 <= 4; ++var9) {
                    var10 = var7.nextInt(8);
                    this.generateBox(var0, var4, var8, var9, 0, var8, var9, var10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
            var8 = var7.nextInt(8);
            this.generateBox(var0, var4, 0, 5, 0, 0, 5, var8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            var8 = var7.nextInt(8);
            this.generateBox(var0, var4, 4, 5, 0, 4, 5, var8, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            for (var8 = 0; var8 <= 4; ++var8) {
                var9 = var7.nextInt(5);
                this.generateBox(var0, var4, var8, 2, 0, var8, 2, var9, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
            }
            for (var8 = 0; var8 <= 4; ++var8) {
                for (var9 = 0; var9 <= 1; ++var9) {
                    var10 = var7.nextInt(3);
                    this.generateBox(var0, var4, var8, var9, 0, var8, var9, var10, Blocks.NETHER_BRICKS.defaultBlockState(), Blocks.NETHER_BRICKS.defaultBlockState(), false);
                }
            }
        }
    }

    public static class q
    extends a {
        @Nullable n previousPiece;
        final List<n> availableBridgePieces = new ArrayList<n>();
        final List<n> availableCastlePieces = new ArrayList<n>();
        public final List<StructurePiece> pendingChildren = Lists.newArrayList();

        public q(RandomSource var0, int var1, int var2) {
            super(var1, var2, q.getRandomHorizontalDirection(var0));
            for (n var6 : BRIDGE_PIECE_WEIGHTS) {
                var6.placeCount = 0;
                this.availableBridgePieces.add(var6);
            }
            for (n var6 : CASTLE_PIECE_WEIGHTS) {
                var6.placeCount = 0;
                this.availableCastlePieces.add(var6);
            }
        }

        public q(NBTTagCompound var0) {
            super(WorldGenFeatureStructurePieceType.NETHER_FORTRESS_START, var0);
        }
    }

    static abstract class m
    extends StructurePiece {
        protected m(WorldGenFeatureStructurePieceType var0, int var1, StructureBoundingBox var2) {
            super(var0, var1, var2);
        }

        public m(WorldGenFeatureStructurePieceType var0, NBTTagCompound var1) {
            super(var0, var1);
        }

        @Override
        protected void addAdditionalSaveData(StructurePieceSerializationContext var0, NBTTagCompound var1) {
        }

        private int updatePieceWeight(List<n> var0) {
            boolean var1 = false;
            int var2 = 0;
            for (n var4 : var0) {
                if (var4.maxPlaceCount > 0 && var4.placeCount < var4.maxPlaceCount) {
                    var1 = true;
                }
                var2 += var4.weight;
            }
            return var1 ? var2 : -1;
        }

        private @Nullable m generatePiece(q var0, List<n> var1, StructurePieceAccessor var2, RandomSource var3, int var4, int var5, int var6, EnumDirection var7, int var8) {
            int var9 = this.updatePieceWeight(var1);
            boolean var10 = var9 > 0 && var8 <= 30;
            int var11 = 0;
            block0: while (var11 < 5 && var10) {
                ++var11;
                int var12 = var3.nextInt(var9);
                for (n var14 : var1) {
                    if ((var12 -= var14.weight) >= 0) continue;
                    if (!var14.doPlace(var8) || var14 == var0.previousPiece && !var14.allowInRow) continue block0;
                    m var15 = NetherFortressPieces.findAndCreateBridgePieceFactory(var14, var2, var3, var4, var5, var6, var7, var8);
                    if (var15 == null) continue;
                    ++var14.placeCount;
                    var0.previousPiece = var14;
                    if (!var14.isValid()) {
                        var1.remove(var14);
                    }
                    return var15;
                }
            }
            return b.createPiece(var2, var3, var4, var5, var6, var7, var8);
        }

        private @Nullable StructurePiece generateAndAddPiece(q var0, StructurePieceAccessor var1, RandomSource var2, int var3, int var4, int var5, EnumDirection var6, int var7, boolean var8) {
            m var10;
            if (Math.abs(var3 - var0.getBoundingBox().minX()) > 112 || Math.abs(var5 - var0.getBoundingBox().minZ()) > 112) {
                return b.createPiece(var1, var2, var3, var4, var5, var6, var7);
            }
            List<n> var9 = var0.availableBridgePieces;
            if (var8) {
                var9 = var0.availableCastlePieces;
            }
            if ((var10 = this.generatePiece(var0, var9, var1, var2, var3, var4, var5, var6, var7 + 1)) != null) {
                var1.addPiece(var10);
                var0.pendingChildren.add(var10);
            }
            return var10;
        }

        protected @Nullable StructurePiece generateChildForward(q var0, StructurePieceAccessor var1, RandomSource var2, int var3, int var4, boolean var5) {
            EnumDirection var6 = this.getOrientation();
            if (var6 != null) {
                switch (var6) {
                    case NORTH: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var3, this.boundingBox.minY() + var4, this.boundingBox.minZ() - 1, var6, this.getGenDepth(), var5);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var3, this.boundingBox.minY() + var4, this.boundingBox.maxZ() + 1, var6, this.getGenDepth(), var5);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + var4, this.boundingBox.minZ() + var3, var6, this.getGenDepth(), var5);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + var4, this.boundingBox.minZ() + var3, var6, this.getGenDepth(), var5);
                    }
                }
            }
            return null;
        }

        protected @Nullable StructurePiece generateChildLeft(q var0, StructurePieceAccessor var1, RandomSource var2, int var3, int var4, boolean var5) {
            EnumDirection var6 = this.getOrientation();
            if (var6 != null) {
                switch (var6) {
                    case NORTH: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.WEST, this.getGenDepth(), var5);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() - 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.WEST, this.getGenDepth(), var5);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth(), var5);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.minZ() - 1, EnumDirection.NORTH, this.getGenDepth(), var5);
                    }
                }
            }
            return null;
        }

        protected @Nullable StructurePiece generateChildRight(q var0, StructurePieceAccessor var1, RandomSource var2, int var3, int var4, boolean var5) {
            EnumDirection var6 = this.getOrientation();
            if (var6 != null) {
                switch (var6) {
                    case NORTH: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.EAST, this.getGenDepth(), var5);
                    }
                    case SOUTH: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.maxX() + 1, this.boundingBox.minY() + var3, this.boundingBox.minZ() + var4, EnumDirection.EAST, this.getGenDepth(), var5);
                    }
                    case WEST: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth(), var5);
                    }
                    case EAST: {
                        return this.generateAndAddPiece(var0, var1, var2, this.boundingBox.minX() + var4, this.boundingBox.minY() + var3, this.boundingBox.maxZ() + 1, EnumDirection.SOUTH, this.getGenDepth(), var5);
                    }
                }
            }
            return null;
        }

        protected static boolean isOkBox(StructureBoundingBox var0) {
            return var0.minY() > 10;
        }
    }
}

