/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ILightAccess;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.lighting.ChunkSkyLightSources;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.lighting.LightEngineStorageSky;
import org.jspecify.annotations.Nullable;

public final class LightEngineSky
extends LightEngine<LightEngineStorageSky.a, LightEngineStorageSky> {
    private static final long REMOVE_TOP_SKY_SOURCE_ENTRY = LightEngine.a.decreaseAllDirections(15);
    private static final long REMOVE_SKY_SOURCE_ENTRY = LightEngine.a.decreaseSkipOneDirection(15, EnumDirection.UP);
    private static final long ADD_SKY_SOURCE_ENTRY = LightEngine.a.increaseSkipOneDirection(15, false, EnumDirection.UP);
    private final BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();
    private final ChunkSkyLightSources emptyChunkSources;

    public LightEngineSky(ILightAccess var0) {
        this(var0, new LightEngineStorageSky(var0));
    }

    @VisibleForTesting
    protected LightEngineSky(ILightAccess var0, LightEngineStorageSky var1) {
        super(var0, var1);
        this.emptyChunkSources = new ChunkSkyLightSources(var0.getLevel());
    }

    private static boolean isSourceLevel(int var0) {
        return var0 == 15;
    }

    private int getLowestSourceY(int var0, int var1, int var2) {
        ChunkSkyLightSources var3 = this.getChunkSources(SectionPosition.blockToSectionCoord(var0), SectionPosition.blockToSectionCoord(var1));
        if (var3 == null) {
            return var2;
        }
        return var3.getLowestSourceY(SectionPosition.sectionRelative(var0), SectionPosition.sectionRelative(var1));
    }

    private @Nullable ChunkSkyLightSources getChunkSources(int var0, int var1) {
        LightChunk var2 = this.chunkSource.getChunkForLighting(var0, var1);
        return var2 != null ? var2.getSkyLightSources() : null;
    }

    @Override
    protected void checkNode(long var0) {
        boolean var8;
        int var7;
        int var2 = BlockPosition.getX(var0);
        int var3 = BlockPosition.getY(var0);
        int var4 = BlockPosition.getZ(var0);
        long var5 = SectionPosition.blockToSection(var0);
        int n2 = var7 = ((LightEngineStorageSky)this.storage).lightOnInSection(var5) ? this.getLowestSourceY(var2, var4, Integer.MAX_VALUE) : Integer.MAX_VALUE;
        if (var7 != Integer.MAX_VALUE) {
            this.updateSourcesInColumn(var2, var4, var7);
        }
        if (!((LightEngineStorageSky)this.storage).storingLightForSection(var5)) {
            return;
        }
        boolean bl = var8 = var3 >= var7;
        if (var8) {
            this.enqueueDecrease(var0, REMOVE_SKY_SOURCE_ENTRY);
            this.enqueueIncrease(var0, ADD_SKY_SOURCE_ENTRY);
        } else {
            int var9 = ((LightEngineStorageSky)this.storage).getStoredLevel(var0);
            if (var9 > 0) {
                ((LightEngineStorageSky)this.storage).setStoredLevel(var0, 0);
                this.enqueueDecrease(var0, LightEngine.a.decreaseAllDirections(var9));
            } else {
                this.enqueueDecrease(var0, PULL_LIGHT_IN_ENTRY);
            }
        }
    }

    private void updateSourcesInColumn(int var0, int var1, int var2) {
        int var3 = SectionPosition.sectionToBlockCoord(((LightEngineStorageSky)this.storage).getBottomSectionY());
        this.removeSourcesBelow(var0, var1, var2, var3);
        this.addSourcesAbove(var0, var1, var2, var3);
    }

    private void removeSourcesBelow(int var0, int var1, int var2, int var3) {
        if (var2 <= var3) {
            return;
        }
        int var4 = SectionPosition.blockToSectionCoord(var0);
        int var5 = SectionPosition.blockToSectionCoord(var1);
        int var6 = var2 - 1;
        int var7 = SectionPosition.blockToSectionCoord(var6);
        while (((LightEngineStorageSky)this.storage).hasLightDataAtOrBelow(var7)) {
            if (((LightEngineStorageSky)this.storage).storingLightForSection(SectionPosition.asLong(var4, var7, var5))) {
                int var8 = SectionPosition.sectionToBlockCoord(var7);
                int var9 = var8 + 15;
                for (int var10 = Math.min(var9, var6); var10 >= var8; --var10) {
                    long var11 = BlockPosition.asLong(var0, var10, var1);
                    if (!LightEngineSky.isSourceLevel(((LightEngineStorageSky)this.storage).getStoredLevel(var11))) {
                        return;
                    }
                    ((LightEngineStorageSky)this.storage).setStoredLevel(var11, 0);
                    this.enqueueDecrease(var11, var10 == var2 - 1 ? REMOVE_TOP_SKY_SOURCE_ENTRY : REMOVE_SKY_SOURCE_ENTRY);
                }
            }
            --var7;
        }
    }

    private void addSourcesAbove(int var0, int var1, int var2, int var3) {
        int var4 = SectionPosition.blockToSectionCoord(var0);
        int var5 = SectionPosition.blockToSectionCoord(var1);
        int var6 = Math.max(Math.max(this.getLowestSourceY(var0 - 1, var1, Integer.MIN_VALUE), this.getLowestSourceY(var0 + 1, var1, Integer.MIN_VALUE)), Math.max(this.getLowestSourceY(var0, var1 - 1, Integer.MIN_VALUE), this.getLowestSourceY(var0, var1 + 1, Integer.MIN_VALUE)));
        int var7 = Math.max(var2, var3);
        long var8 = SectionPosition.asLong(var4, SectionPosition.blockToSectionCoord(var7), var5);
        while (!((LightEngineStorageSky)this.storage).isAboveData(var8)) {
            if (((LightEngineStorageSky)this.storage).storingLightForSection(var8)) {
                int var10 = SectionPosition.sectionToBlockCoord(SectionPosition.y(var8));
                int var11 = var10 + 15;
                for (int var12 = Math.max(var10, var7); var12 <= var11; ++var12) {
                    long var13 = BlockPosition.asLong(var0, var12, var1);
                    if (LightEngineSky.isSourceLevel(((LightEngineStorageSky)this.storage).getStoredLevel(var13))) {
                        return;
                    }
                    ((LightEngineStorageSky)this.storage).setStoredLevel(var13, 15);
                    if (var12 >= var6 && var12 != var2) continue;
                    this.enqueueIncrease(var13, ADD_SKY_SOURCE_ENTRY);
                }
            }
            var8 = SectionPosition.offset(var8, EnumDirection.UP);
        }
    }

    @Override
    protected void propagateIncrease(long var0, long var2, int var4) {
        IBlockData var5 = null;
        int var6 = this.countEmptySectionsBelowIfAtBorder(var0);
        for (EnumDirection var10 : PROPAGATION_DIRECTIONS) {
            int var13;
            int var14;
            long var11;
            if (!LightEngine.a.shouldPropagateInDirection(var2, var10) || !((LightEngineStorageSky)this.storage).storingLightForSection(SectionPosition.blockToSection(var11 = BlockPosition.offset(var0, var10))) || (var14 = var4 - 1) <= (var13 = ((LightEngineStorageSky)this.storage).getStoredLevel(var11))) continue;
            this.mutablePos.set(var11);
            IBlockData var15 = this.getState(this.mutablePos);
            int var16 = var4 - this.getOpacity(var15);
            if (var16 <= var13) continue;
            if (var5 == null) {
                IBlockData iBlockData = var5 = LightEngine.a.isFromEmptyShape(var2) ? Blocks.AIR.defaultBlockState() : this.getState(this.mutablePos.set(var0));
            }
            if (this.shapeOccludes(var5, var15, var10)) continue;
            ((LightEngineStorageSky)this.storage).setStoredLevel(var11, var16);
            if (var16 > 1) {
                this.enqueueIncrease(var11, LightEngine.a.increaseSkipOneDirection(var16, LightEngineSky.isEmptyShape(var15), var10.getOpposite()));
            }
            this.propagateFromEmptySections(var11, var10, var16, true, var6);
        }
    }

    @Override
    protected void propagateDecrease(long var0, long var2) {
        int var4 = this.countEmptySectionsBelowIfAtBorder(var0);
        int var5 = LightEngine.a.getFromLevel(var2);
        for (EnumDirection var9 : PROPAGATION_DIRECTIONS) {
            int var12;
            long var10;
            if (!LightEngine.a.shouldPropagateInDirection(var2, var9) || !((LightEngineStorageSky)this.storage).storingLightForSection(SectionPosition.blockToSection(var10 = BlockPosition.offset(var0, var9))) || (var12 = ((LightEngineStorageSky)this.storage).getStoredLevel(var10)) == 0) continue;
            if (var12 <= var5 - 1) {
                ((LightEngineStorageSky)this.storage).setStoredLevel(var10, 0);
                this.enqueueDecrease(var10, LightEngine.a.decreaseSkipOneDirection(var12, var9.getOpposite()));
                this.propagateFromEmptySections(var10, var9, var12, false, var4);
                continue;
            }
            this.enqueueIncrease(var10, LightEngine.a.increaseOnlyOneDirection(var12, false, var9.getOpposite()));
        }
    }

    private int countEmptySectionsBelowIfAtBorder(long var0) {
        int var2 = BlockPosition.getY(var0);
        int var3 = SectionPosition.sectionRelative(var2);
        if (var3 != 0) {
            return 0;
        }
        int var4 = BlockPosition.getX(var0);
        int var5 = BlockPosition.getZ(var0);
        int var6 = SectionPosition.sectionRelative(var4);
        int var7 = SectionPosition.sectionRelative(var5);
        if (var6 == 0 || var6 == 15 || var7 == 0 || var7 == 15) {
            int var8 = SectionPosition.blockToSectionCoord(var4);
            int var9 = SectionPosition.blockToSectionCoord(var2);
            int var10 = SectionPosition.blockToSectionCoord(var5);
            int var11 = 0;
            while (!((LightEngineStorageSky)this.storage).storingLightForSection(SectionPosition.asLong(var8, var9 - var11 - 1, var10)) && ((LightEngineStorageSky)this.storage).hasLightDataAtOrBelow(var9 - var11 - 1)) {
                ++var11;
            }
            return var11;
        }
        return 0;
    }

    private void propagateFromEmptySections(long var0, EnumDirection var2, int var3, boolean var4, int var5) {
        if (var5 == 0) {
            return;
        }
        int var6 = BlockPosition.getX(var0);
        int var7 = BlockPosition.getZ(var0);
        if (!LightEngineSky.crossedSectionEdge(var2, SectionPosition.sectionRelative(var6), SectionPosition.sectionRelative(var7))) {
            return;
        }
        int var8 = BlockPosition.getY(var0);
        int var9 = SectionPosition.blockToSectionCoord(var6);
        int var10 = SectionPosition.blockToSectionCoord(var7);
        int var11 = SectionPosition.blockToSectionCoord(var8) - 1;
        int var12 = var11 - var5 + 1;
        while (var11 >= var12) {
            if (!((LightEngineStorageSky)this.storage).storingLightForSection(SectionPosition.asLong(var9, var11, var10))) {
                --var11;
                continue;
            }
            int var13 = SectionPosition.sectionToBlockCoord(var11);
            for (int var14 = 15; var14 >= 0; --var14) {
                long var15 = BlockPosition.asLong(var6, var13 + var14, var7);
                if (var4) {
                    ((LightEngineStorageSky)this.storage).setStoredLevel(var15, var3);
                    if (var3 <= 1) continue;
                    this.enqueueIncrease(var15, LightEngine.a.increaseSkipOneDirection(var3, true, var2.getOpposite()));
                    continue;
                }
                ((LightEngineStorageSky)this.storage).setStoredLevel(var15, 0);
                this.enqueueDecrease(var15, LightEngine.a.decreaseSkipOneDirection(var3, var2.getOpposite()));
            }
            --var11;
        }
    }

    private static boolean crossedSectionEdge(EnumDirection var0, int var1, int var2) {
        return switch (var0) {
            case EnumDirection.NORTH -> {
                if (var2 == 15) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.SOUTH -> {
                if (var2 == 0) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.WEST -> {
                if (var1 == 15) {
                    yield true;
                }
                yield false;
            }
            case EnumDirection.EAST -> {
                if (var1 == 0) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    @Override
    public void setLightEnabled(ChunkCoordIntPair var0, boolean var1) {
        super.setLightEnabled(var0, var1);
        if (var1) {
            ChunkSkyLightSources var2 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z), this.emptyChunkSources);
            int var3 = var2.getHighestLowestSourceY() - 1;
            int var4 = SectionPosition.blockToSectionCoord(var3) + 1;
            long var5 = SectionPosition.getZeroNode(var0.x, var0.z);
            int var7 = ((LightEngineStorageSky)this.storage).getTopSectionY(var5);
            int var8 = Math.max(((LightEngineStorageSky)this.storage).getBottomSectionY(), var4);
            for (int var9 = var7 - 1; var9 >= var8; --var9) {
                NibbleArray var10 = ((LightEngineStorageSky)this.storage).getDataLayerToWrite(SectionPosition.asLong(var0.x, var9, var0.z));
                if (var10 == null || !var10.isEmpty()) continue;
                var10.fill(15);
            }
        }
    }

    @Override
    public void propagateLightSources(ChunkCoordIntPair var0) {
        long var1 = SectionPosition.getZeroNode(var0.x, var0.z);
        ((LightEngineStorageSky)this.storage).setLightEnabled(var1, true);
        ChunkSkyLightSources var3 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z), this.emptyChunkSources);
        ChunkSkyLightSources var4 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z - 1), this.emptyChunkSources);
        ChunkSkyLightSources var5 = Objects.requireNonNullElse(this.getChunkSources(var0.x, var0.z + 1), this.emptyChunkSources);
        ChunkSkyLightSources var6 = Objects.requireNonNullElse(this.getChunkSources(var0.x - 1, var0.z), this.emptyChunkSources);
        ChunkSkyLightSources var7 = Objects.requireNonNullElse(this.getChunkSources(var0.x + 1, var0.z), this.emptyChunkSources);
        int var8 = ((LightEngineStorageSky)this.storage).getTopSectionY(var1);
        int var9 = ((LightEngineStorageSky)this.storage).getBottomSectionY();
        int var10 = SectionPosition.sectionToBlockCoord(var0.x);
        int var11 = SectionPosition.sectionToBlockCoord(var0.z);
        for (int var12 = var8 - 1; var12 >= var9; --var12) {
            long var13 = SectionPosition.asLong(var0.x, var12, var0.z);
            NibbleArray var15 = ((LightEngineStorageSky)this.storage).getDataLayerToWrite(var13);
            if (var15 == null) continue;
            int var16 = SectionPosition.sectionToBlockCoord(var12);
            int var17 = var16 + 15;
            boolean var18 = false;
            for (int var19 = 0; var19 < 16; ++var19) {
                for (int var20 = 0; var20 < 16; ++var20) {
                    int var21 = var3.getLowestSourceY(var20, var19);
                    if (var21 > var17) continue;
                    int var22 = var19 == 0 ? var4.getLowestSourceY(var20, 15) : var3.getLowestSourceY(var20, var19 - 1);
                    int var23 = var19 == 15 ? var5.getLowestSourceY(var20, 0) : var3.getLowestSourceY(var20, var19 + 1);
                    int var24 = var20 == 0 ? var6.getLowestSourceY(15, var19) : var3.getLowestSourceY(var20 - 1, var19);
                    int var25 = var20 == 15 ? var7.getLowestSourceY(0, var19) : var3.getLowestSourceY(var20 + 1, var19);
                    int var26 = Math.max(Math.max(var22, var23), Math.max(var24, var25));
                    for (int var27 = var17; var27 >= Math.max(var16, var21); --var27) {
                        var15.set(var20, SectionPosition.sectionRelative(var27), var19, 15);
                        if (var27 != var21 && var27 >= var26) continue;
                        long var28 = BlockPosition.asLong(var10 + var20, var27, var11 + var19);
                        this.enqueueIncrease(var28, LightEngine.a.increaseSkySourceInDirections(var27 == var21, var27 < var22, var27 < var23, var27 < var24, var27 < var25));
                    }
                    if (var21 >= var16) continue;
                    var18 = true;
                }
            }
            if (!var18) break;
        }
    }
}

