/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ICollisionAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathTypeCache;
import net.minecraft.world.level.pathfinder.PathfinderNormal;
import org.jspecify.annotations.Nullable;

public class PathfindingContext {
    private final ICollisionAccess level;
    private final @Nullable PathTypeCache cache;
    private final BlockPosition mobPosition;
    private final BlockPosition.MutableBlockPosition mutablePos = new BlockPosition.MutableBlockPosition();

    public PathfindingContext(ICollisionAccess var0, EntityInsentient var1) {
        this.level = var0;
        World world = var1.level();
        if (world instanceof WorldServer) {
            WorldServer var2 = (WorldServer)world;
            this.cache = var2.getPathTypeCache();
        } else {
            this.cache = null;
        }
        this.mobPosition = var1.blockPosition();
    }

    public PathType getPathTypeFromState(int var0, int var1, int var2) {
        BlockPosition.MutableBlockPosition var3 = this.mutablePos.set(var0, var1, var2);
        if (this.cache == null) {
            return PathfinderNormal.getPathTypeFromState(this.level, var3);
        }
        return this.cache.getOrCompute(this.level, var3);
    }

    public IBlockData getBlockState(BlockPosition var0) {
        return this.level.getBlockState(var0);
    }

    public ICollisionAccess level() {
        return this.level;
    }

    public BlockPosition mobPosition() {
        return this.mobPosition;
    }
}

