/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.portal;

import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.BlockUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.BlockPortal;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jspecify.annotations.Nullable;

public class BlockPortalShape {
    private static final int MIN_WIDTH = 2;
    public static final int MAX_WIDTH = 21;
    private static final int MIN_HEIGHT = 3;
    public static final int MAX_HEIGHT = 21;
    private static final BlockBase.f FRAME = (var0, var1, var2) -> var0.is(Blocks.OBSIDIAN);
    private static final float SAFE_TRAVEL_MAX_ENTITY_XY = 4.0f;
    private static final double SAFE_TRAVEL_MAX_VERTICAL_DELTA = 1.0;
    private final EnumDirection.EnumAxis axis;
    private final EnumDirection rightDir;
    private final int numPortalBlocks;
    private final BlockPosition bottomLeft;
    private final int height;
    private final int width;

    private BlockPortalShape(EnumDirection.EnumAxis var0, int var1, EnumDirection var2, BlockPosition var3, int var4, int var5) {
        this.axis = var0;
        this.numPortalBlocks = var1;
        this.rightDir = var2;
        this.bottomLeft = var3;
        this.width = var4;
        this.height = var5;
    }

    public static Optional<BlockPortalShape> findEmptyPortalShape(GeneratorAccess var02, BlockPosition var1, EnumDirection.EnumAxis var2) {
        return BlockPortalShape.findPortalShape(var02, var1, var0 -> var0.isValid() && var0.numPortalBlocks == 0, var2);
    }

    public static Optional<BlockPortalShape> findPortalShape(GeneratorAccess var0, BlockPosition var1, Predicate<BlockPortalShape> var2, EnumDirection.EnumAxis var3) {
        Optional<BlockPortalShape> var4 = Optional.of(BlockPortalShape.findAnyShape(var0, var1, var3)).filter(var2);
        if (var4.isPresent()) {
            return var4;
        }
        EnumDirection.EnumAxis var5 = var3 == EnumDirection.EnumAxis.X ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.X;
        return Optional.of(BlockPortalShape.findAnyShape(var0, var1, var5)).filter(var2);
    }

    public static BlockPortalShape findAnyShape(IBlockAccess var0, BlockPosition var1, EnumDirection.EnumAxis var2) {
        EnumDirection var3 = var2 == EnumDirection.EnumAxis.X ? EnumDirection.WEST : EnumDirection.SOUTH;
        BlockPosition var4 = BlockPortalShape.calculateBottomLeft(var0, var3, var1);
        if (var4 == null) {
            return new BlockPortalShape(var2, 0, var3, var1, 0, 0);
        }
        int var5 = BlockPortalShape.calculateWidth(var0, var4, var3);
        if (var5 == 0) {
            return new BlockPortalShape(var2, 0, var3, var4, 0, 0);
        }
        MutableInt var6 = new MutableInt();
        int var7 = BlockPortalShape.calculateHeight(var0, var4, var3, var5, var6);
        return new BlockPortalShape(var2, var6.intValue(), var3, var4, var5, var7);
    }

    private static @Nullable BlockPosition calculateBottomLeft(IBlockAccess var0, EnumDirection var1, BlockPosition var2) {
        int var3 = Math.max(var0.getMinY(), var2.getY() - 21);
        while (var2.getY() > var3 && BlockPortalShape.isEmpty(var0.getBlockState(var2.below()))) {
            var2 = var2.below();
        }
        EnumDirection var4 = var1.getOpposite();
        int var5 = BlockPortalShape.getDistanceUntilEdgeAboveFrame(var0, var2, var4) - 1;
        if (var5 < 0) {
            return null;
        }
        return var2.relative(var4, var5);
    }

    private static int calculateWidth(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        int var3 = BlockPortalShape.getDistanceUntilEdgeAboveFrame(var0, var1, var2);
        if (var3 < 2 || var3 > 21) {
            return 0;
        }
        return var3;
    }

    private static int getDistanceUntilEdgeAboveFrame(IBlockAccess var0, BlockPosition var1, EnumDirection var2) {
        BlockPosition.MutableBlockPosition var3 = new BlockPosition.MutableBlockPosition();
        for (int var4 = 0; var4 <= 21; ++var4) {
            var3.set(var1).move(var2, var4);
            IBlockData var5 = var0.getBlockState(var3);
            if (!BlockPortalShape.isEmpty(var5)) {
                if (!FRAME.test(var5, var0, var3)) break;
                return var4;
            }
            IBlockData var6 = var0.getBlockState(var3.move(EnumDirection.DOWN));
            if (!FRAME.test(var6, var0, var3)) break;
        }
        return 0;
    }

    private static int calculateHeight(IBlockAccess var0, BlockPosition var1, EnumDirection var2, int var3, MutableInt var4) {
        BlockPosition.MutableBlockPosition var5 = new BlockPosition.MutableBlockPosition();
        int var6 = BlockPortalShape.getDistanceUntilTop(var0, var1, var2, var5, var3, var4);
        if (var6 < 3 || var6 > 21 || !BlockPortalShape.hasTopFrame(var0, var1, var2, var5, var3, var6)) {
            return 0;
        }
        return var6;
    }

    private static boolean hasTopFrame(IBlockAccess var0, BlockPosition var1, EnumDirection var2, BlockPosition.MutableBlockPosition var3, int var4, int var5) {
        for (int var6 = 0; var6 < var4; ++var6) {
            BlockPosition.MutableBlockPosition var7 = var3.set(var1).move(EnumDirection.UP, var5).move(var2, var6);
            if (FRAME.test(var0.getBlockState(var7), var0, var7)) continue;
            return false;
        }
        return true;
    }

    private static int getDistanceUntilTop(IBlockAccess var0, BlockPosition var1, EnumDirection var2, BlockPosition.MutableBlockPosition var3, int var4, MutableInt var5) {
        for (int var6 = 0; var6 < 21; ++var6) {
            var3.set(var1).move(EnumDirection.UP, var6).move(var2, -1);
            if (!FRAME.test(var0.getBlockState(var3), var0, var3)) {
                return var6;
            }
            var3.set(var1).move(EnumDirection.UP, var6).move(var2, var4);
            if (!FRAME.test(var0.getBlockState(var3), var0, var3)) {
                return var6;
            }
            for (int var7 = 0; var7 < var4; ++var7) {
                var3.set(var1).move(EnumDirection.UP, var6).move(var2, var7);
                IBlockData var8 = var0.getBlockState(var3);
                if (!BlockPortalShape.isEmpty(var8)) {
                    return var6;
                }
                if (!var8.is(Blocks.NETHER_PORTAL)) continue;
                var5.increment();
            }
        }
        return 21;
    }

    private static boolean isEmpty(IBlockData var0) {
        return var0.isAir() || var0.is(TagsBlock.FIRE) || var0.is(Blocks.NETHER_PORTAL);
    }

    public boolean isValid() {
        return this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks(GeneratorAccess var0) {
        IBlockData var1 = (IBlockData)Blocks.NETHER_PORTAL.defaultBlockState().setValue(BlockPortal.AXIS, this.axis);
        BlockPosition.betweenClosed(this.bottomLeft, this.bottomLeft.relative(EnumDirection.UP, this.height - 1).relative(this.rightDir, this.width - 1)).forEach(var2 -> var0.setBlock((BlockPosition)var2, var1, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }

    public static Vec3D getRelativePosition(BlockUtil.Rectangle var0, EnumDirection.EnumAxis var1, Vec3D var2, EntitySize var3) {
        EnumDirection.EnumAxis var13;
        double var9;
        double var11;
        double var4 = (double)var0.axis1Size - (double)var3.width();
        double var6 = (double)var0.axis2Size - (double)var3.height();
        BlockPosition var8 = var0.minCorner;
        if (var4 > 0.0) {
            var11 = (double)var8.get(var1) + (double)var3.width() / 2.0;
            var9 = MathHelper.clamp(MathHelper.inverseLerp(var2.get(var1) - var11, 0.0, var4), 0.0, 1.0);
        } else {
            var9 = 0.5;
        }
        if (var6 > 0.0) {
            var13 = EnumDirection.EnumAxis.Y;
            var11 = MathHelper.clamp(MathHelper.inverseLerp(var2.get(var13) - (double)var8.get(var13), 0.0, var6), 0.0, 1.0);
        } else {
            var11 = 0.0;
        }
        var13 = var1 == EnumDirection.EnumAxis.X ? EnumDirection.EnumAxis.Z : EnumDirection.EnumAxis.X;
        double var14 = var2.get(var13) - ((double)var8.get(var13) + 0.5);
        return new Vec3D(var9, var11, var14);
    }

    public static Vec3D findCollisionFreePosition(Vec3D var0, WorldServer var1, Entity var22, EntitySize var3) {
        if (var3.width() > 4.0f || var3.height() > 4.0f) {
            return var0;
        }
        double var4 = (double)var3.height() / 2.0;
        Vec3D var6 = var0.add(0.0, var4, 0.0);
        VoxelShape var7 = VoxelShapes.create(AxisAlignedBB.ofSize(var6, var3.width(), 0.0, var3.width()).expandTowards(0.0, 1.0, 0.0).inflate(1.0E-6));
        Optional<Vec3D> var8 = var1.findFreePosition(var22, var7, var6, var3.width(), var3.height(), var3.width());
        Optional<Vec3D> var9 = var8.map(var2 -> var2.subtract(0.0, var4, 0.0));
        return var9.orElse(var0);
    }
}

