/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.redstone;

import com.mojang.logging.LogUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.NeighborUpdater;
import net.minecraft.world.level.redstone.Orientation;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class CollectingNeighborUpdater
implements NeighborUpdater {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final World level;
    private final int maxChainedNeighborUpdates;
    private final ArrayDeque<c> stack = new ArrayDeque();
    private final List<c> addedThisLayer = new ArrayList<c>();
    private int count = 0;
    private @Nullable Consumer<BlockPosition> debugListener;

    public CollectingNeighborUpdater(World var0, int var1) {
        this.level = var0;
        this.maxChainedNeighborUpdates = var1;
    }

    public void setDebugListener(@Nullable Consumer<BlockPosition> var0) {
        this.debugListener = var0;
    }

    @Override
    public void shapeUpdate(EnumDirection var0, IBlockData var1, BlockPosition var2, BlockPosition var3, @Block.b int var4, int var5) {
        this.addAndRun(var2, new d(var0, var1, var2.immutable(), var3.immutable(), var4, var5));
    }

    @Override
    public void neighborChanged(BlockPosition var0, Block var1, @Nullable Orientation var2) {
        this.addAndRun(var0, new e(var0, var1, var2));
    }

    @Override
    public void neighborChanged(IBlockData var0, BlockPosition var1, Block var2, @Nullable Orientation var3, boolean var4) {
        this.addAndRun(var1, new a(var0, var1.immutable(), var2, var3, var4));
    }

    @Override
    public void updateNeighborsAtExceptFromFacing(BlockPosition var0, Block var1, @Nullable EnumDirection var2, @Nullable Orientation var3) {
        this.addAndRun(var0, new b(var0.immutable(), var1, var3, var2));
    }

    private void addAndRun(BlockPosition var0, c var1) {
        boolean var2 = this.count > 0;
        boolean var3 = this.maxChainedNeighborUpdates >= 0 && this.count >= this.maxChainedNeighborUpdates;
        ++this.count;
        if (!var3) {
            if (var2) {
                this.addedThisLayer.add(var1);
            } else {
                this.stack.push(var1);
            }
        } else if (this.count - 1 == this.maxChainedNeighborUpdates) {
            LOGGER.error("Too many chained neighbor updates. Skipping the rest. First skipped position: {}", (Object)var0.toShortString());
        }
        if (!var2) {
            this.runUpdates();
        }
    }

    private void runUpdates() {
        try {
            block3: while (!this.stack.isEmpty() || !this.addedThisLayer.isEmpty()) {
                for (int var0 = this.addedThisLayer.size() - 1; var0 >= 0; --var0) {
                    this.stack.push(this.addedThisLayer.get(var0));
                }
                this.addedThisLayer.clear();
                c var0 = this.stack.peek();
                if (this.debugListener != null) {
                    var0.forEachUpdatedPos(this.debugListener);
                }
                while (this.addedThisLayer.isEmpty()) {
                    if (var0.runNext(this.level)) continue;
                    this.stack.pop();
                    continue block3;
                }
            }
        }
        finally {
            this.stack.clear();
            this.addedThisLayer.clear();
            this.count = 0;
        }
    }

    record d(EnumDirection direction, IBlockData neighborState, BlockPosition pos, BlockPosition neighborPos, @Block.b int updateFlags, int updateLimit) implements c
    {
        @Override
        public boolean runNext(World var0) {
            NeighborUpdater.executeShapeUpdate(var0, this.direction, this.pos, this.neighborPos, this.neighborState, this.updateFlags, this.updateLimit);
            return false;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPosition> var0) {
            var0.accept(this.pos);
        }
    }

    static interface c {
        public boolean runNext(World var1);

        public void forEachUpdatedPos(Consumer<BlockPosition> var1);
    }

    record e(BlockPosition pos, Block block, @Nullable Orientation orientation) implements c
    {
        @Override
        public boolean runNext(World var0) {
            IBlockData var1 = var0.getBlockState(this.pos);
            NeighborUpdater.executeUpdate(var0, var1, this.pos, this.block, this.orientation, false);
            return false;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPosition> var0) {
            var0.accept(this.pos);
        }
    }

    record a(IBlockData state, BlockPosition pos, Block block, @Nullable Orientation orientation, boolean movedByPiston) implements c
    {
        @Override
        public boolean runNext(World var0) {
            NeighborUpdater.executeUpdate(var0, this.state, this.pos, this.block, this.orientation, this.movedByPiston);
            return false;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPosition> var0) {
            var0.accept(this.pos);
        }
    }

    static final class b
    implements c {
        private final BlockPosition sourcePos;
        private final Block sourceBlock;
        private @Nullable Orientation orientation;
        private final @Nullable EnumDirection skipDirection;
        private int idx = 0;

        b(BlockPosition var0, Block var1, @Nullable Orientation var2, @Nullable EnumDirection var3) {
            this.sourcePos = var0;
            this.sourceBlock = var1;
            this.orientation = var2;
            this.skipDirection = var3;
            if (NeighborUpdater.UPDATE_ORDER[this.idx] == var3) {
                ++this.idx;
            }
        }

        @Override
        public boolean runNext(World var0) {
            EnumDirection var1 = NeighborUpdater.UPDATE_ORDER[this.idx++];
            BlockPosition var2 = this.sourcePos.relative(var1);
            IBlockData var3 = var0.getBlockState(var2);
            Orientation var4 = null;
            if (var0.enabledFeatures().contains(FeatureFlags.REDSTONE_EXPERIMENTS)) {
                if (this.orientation == null) {
                    this.orientation = ExperimentalRedstoneUtils.initialOrientation(var0, this.skipDirection == null ? null : this.skipDirection.getOpposite(), null);
                }
                var4 = this.orientation.withFront(var1);
            }
            NeighborUpdater.executeUpdate(var0, var3, var2, this.sourceBlock, var4, false);
            if (this.idx < NeighborUpdater.UPDATE_ORDER.length && NeighborUpdater.UPDATE_ORDER[this.idx] == this.skipDirection) {
                ++this.idx;
            }
            return this.idx < NeighborUpdater.UPDATE_ORDER.length;
        }

        @Override
        public void forEachUpdatedPos(Consumer<BlockPosition> var0) {
            for (EnumDirection var4 : NeighborUpdater.UPDATE_ORDER) {
                if (var4 == this.skipDirection) continue;
                BlockPosition var5 = this.sourcePos.relative(var4);
                var0.accept(var5);
            }
        }
    }
}

