/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryChildren;
import net.minecraft.world.level.storage.loot.entries.LootEntryChildrenAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryType;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootEntryAlternatives
extends LootEntryChildrenAbstract {
    public static final MapCodec<LootEntryAlternatives> CODEC = LootEntryAlternatives.createCodec(LootEntryAlternatives::new);
    public static final ProblemReporter.g UNREACHABLE_PROBLEM = new ProblemReporter.g(){

        @Override
        public String description() {
            return "Unreachable entry!";
        }
    };

    LootEntryAlternatives(List<LootEntryAbstract> var0, List<LootItemCondition> var1) {
        super(var0, var1);
    }

    @Override
    public LootEntryType getType() {
        return LootEntries.ALTERNATIVES;
    }

    @Override
    protected LootEntryChildren compose(List<? extends LootEntryChildren> var0) {
        return switch (var0.size()) {
            case 0 -> ALWAYS_FALSE;
            case 1 -> var0.get(0);
            case 2 -> var0.get(0).or(var0.get(1));
            default -> (var1, var2) -> {
                for (LootEntryChildren var4 : var0) {
                    if (!var4.expand(var1, var2)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        for (int var1 = 0; var1 < this.children.size() - 1; ++var1) {
            if (!((LootEntryAbstract)this.children.get((int)var1)).conditions.isEmpty()) continue;
            var0.reportProblem(UNREACHABLE_PROBLEM);
        }
    }

    public static a alternatives(LootEntryAbstract.a<?> ... var0) {
        return new a(var0);
    }

    public static <E> a alternatives(Collection<E> var0, Function<E, LootEntryAbstract.a<?>> var1) {
        return new a((LootEntryAbstract.a[])var0.stream().map(var1::apply).toArray(LootEntryAbstract.a[]::new));
    }

    public static class a
    extends LootEntryAbstract.a<a> {
        private final ImmutableList.Builder<LootEntryAbstract> entries = ImmutableList.builder();

        public a(LootEntryAbstract.a<?> ... var0) {
            for (LootEntryAbstract.a<?> var4 : var0) {
                this.entries.add((Object)var4.build());
            }
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public a otherwise(LootEntryAbstract.a<?> var0) {
            this.entries.add((Object)var0.build());
            return this;
        }

        @Override
        public LootEntryAbstract build() {
            return new LootEntryAlternatives((List<LootEntryAbstract>)this.entries.build(), this.getConditions());
        }

        @Override
        protected /* synthetic */ LootEntryAbstract.a getThis() {
            return this.getThis();
        }
    }
}

