/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class LootSelectorEntry
extends LootEntryAbstract {
    public static final int DEFAULT_WEIGHT = 1;
    public static final int DEFAULT_QUALITY = 0;
    protected final int weight;
    protected final int quality;
    protected final List<LootItemFunction> functions;
    final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;
    private final LootEntry entry = new c(){

        @Override
        public void createItemStack(Consumer<ItemStack> var0, LootTableInfo var1) {
            LootSelectorEntry.this.createItemStack(LootItemFunction.decorate(LootSelectorEntry.this.compositeFunction, var0, var1), var1);
        }
    };

    protected LootSelectorEntry(int var0, int var1, List<LootItemCondition> var2, List<LootItemFunction> var3) {
        super(var2);
        this.weight = var0;
        this.quality = var1;
        this.functions = var3;
        this.compositeFunction = LootItemFunctions.compose(var3);
    }

    protected static <T extends LootSelectorEntry> Products.P4<RecordCodecBuilder.Mu<T>, Integer, Integer, List<LootItemCondition>, List<LootItemFunction>> singletonFields(RecordCodecBuilder.Instance<T> var02) {
        return var02.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(var0 -> var0.weight), (App)Codec.INT.optionalFieldOf("quality", (Object)0).forGetter(var0 -> var0.quality)).and(LootSelectorEntry.commonFields(var02).t1()).and((App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(var0 -> var0.functions));
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        for (int var1 = 0; var1 < this.functions.size(); ++var1) {
            this.functions.get(var1).validate(var0.forChild(new ProblemReporter.d("functions", var1)));
        }
    }

    protected abstract void createItemStack(Consumer<ItemStack> var1, LootTableInfo var2);

    @Override
    public boolean expand(LootTableInfo var0, Consumer<LootEntry> var1) {
        if (this.canRun(var0)) {
            var1.accept(this.entry);
            return true;
        }
        return false;
    }

    public static a<?> simpleBuilder(d var0) {
        return new b(var0);
    }

    static class b
    extends a<b> {
        private final d constructor;

        public b(d var0) {
            this.constructor = var0;
        }

        @Override
        protected b getThis() {
            return this;
        }

        @Override
        public LootEntryAbstract build() {
            return this.constructor.build(this.weight, this.quality, this.getConditions(), this.getFunctions());
        }

        @Override
        protected /* synthetic */ LootEntryAbstract.a getThis() {
            return this.getThis();
        }
    }

    @FunctionalInterface
    protected static interface d {
        public LootSelectorEntry build(int var1, int var2, List<LootItemCondition> var3, List<LootItemFunction> var4);
    }

    public static abstract class a<T extends a<T>>
    extends LootEntryAbstract.a<T>
    implements LootItemFunctionUser<T> {
        protected int weight = 1;
        protected int quality = 0;
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();

        @Override
        public T apply(LootItemFunction.a var0) {
            this.functions.add((Object)var0.build());
            return (T)((a)this.getThis());
        }

        protected List<LootItemFunction> getFunctions() {
            return this.functions.build();
        }

        public T setWeight(int var0) {
            this.weight = var0;
            return (T)((a)this.getThis());
        }

        public T setQuality(int var0) {
            this.quality = var0;
            return (T)((a)this.getThis());
        }

        @Override
        public /* synthetic */ LootItemFunctionUser unwrap() {
            return (LootItemFunctionUser)((Object)super.unwrap());
        }

        @Override
        public /* synthetic */ LootItemFunctionUser apply(LootItemFunction.a a2) {
            return this.apply(a2);
        }
    }

    protected abstract class c
    implements LootEntry {
        protected c() {
        }

        @Override
        public int getWeight(float var0) {
            return Math.max(MathHelper.floor((float)LootSelectorEntry.this.weight + (float)LootSelectorEntry.this.quality * var0), 0);
        }
    }
}

