/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.ListOperation;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetFireworksFunction
extends LootItemFunctionConditional {
    public static final MapCodec<SetFireworksFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> SetFireworksFunction.commonFields(var02).and(var02.group((App)ListOperation.e.codec(FireworkExplosion.CODEC, 256).optionalFieldOf("explosions").forGetter(var0 -> var0.explosions), (App)ExtraCodecs.UNSIGNED_BYTE.optionalFieldOf("flight_duration").forGetter(var0 -> var0.flightDuration))).apply((Applicative)var02, SetFireworksFunction::new));
    public static final Fireworks DEFAULT_VALUE = new Fireworks(0, List.of());
    private final Optional<ListOperation.e<FireworkExplosion>> explosions;
    private final Optional<Integer> flightDuration;

    protected SetFireworksFunction(List<LootItemCondition> var0, Optional<ListOperation.e<FireworkExplosion>> var1, Optional<Integer> var2) {
        super(var0);
        this.explosions = var1;
        this.flightDuration = var2;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        var0.update(DataComponents.FIREWORKS, DEFAULT_VALUE, this::apply);
        return var0;
    }

    private Fireworks apply(Fireworks var0) {
        return new Fireworks(this.flightDuration.orElseGet(var0::flightDuration), this.explosions.map(var1 -> var1.apply(var0.explosions())).orElse(var0.explosions()));
    }

    public LootItemFunctionType<SetFireworksFunction> getType() {
        return LootItemFunctions.SET_FIREWORKS;
    }
}

