/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public record LootItemConditionTimeCheck(Optional<Long> period, IntRange value) implements LootItemCondition
{
    public static final MapCodec<LootItemConditionTimeCheck> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)Codec.LONG.optionalFieldOf("period").forGetter(LootItemConditionTimeCheck::period), (App)IntRange.CODEC.fieldOf("value").forGetter(LootItemConditionTimeCheck::value)).apply((Applicative)var0, LootItemConditionTimeCheck::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.TIME_CHECK;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.value.getReferencedContextParams();
    }

    @Override
    public boolean test(LootTableInfo var0) {
        WorldServer var1 = var0.getLevel();
        long var2 = var1.getDayTime();
        if (this.period.isPresent()) {
            var2 %= this.period.get().longValue();
        }
        return this.value.test(var0, (int)var2);
    }

    public static a time(IntRange var0) {
        return new a(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private Optional<Long> period = Optional.empty();
        private final IntRange value;

        public a(IntRange var0) {
            this.value = var0;
        }

        public a setPeriod(long var0) {
            this.period = Optional.of(var0);
            return this;
        }

        @Override
        public LootItemConditionTimeCheck build() {
            return new LootItemConditionTimeCheck(this.period, this.value);
        }

        @Override
        public /* synthetic */ LootItemCondition build() {
            return this.build();
        }
    }
}

