/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.EnchantmentActiveCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionBlockStateProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionDamageSourceProperties;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityProperty;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionEntityScore;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionInverted;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionKilledByPlayer;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionLocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionMatchTool;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionRandomChance;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionSurvivesExplosion;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTableBonus;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionTimeCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionWeatherCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceWithEnchantedBonusCondition;
import net.minecraft.world.level.storage.loot.predicates.ValueCheckCondition;

public class LootItemConditions {
    public static final LootItemConditionType INVERTED = LootItemConditions.register("inverted", LootItemConditionInverted.CODEC);
    public static final LootItemConditionType ANY_OF = LootItemConditions.register("any_of", AnyOfCondition.CODEC);
    public static final LootItemConditionType ALL_OF = LootItemConditions.register("all_of", AllOfCondition.CODEC);
    public static final LootItemConditionType RANDOM_CHANCE = LootItemConditions.register("random_chance", LootItemConditionRandomChance.CODEC);
    public static final LootItemConditionType RANDOM_CHANCE_WITH_ENCHANTED_BONUS = LootItemConditions.register("random_chance_with_enchanted_bonus", LootItemRandomChanceWithEnchantedBonusCondition.CODEC);
    public static final LootItemConditionType ENTITY_PROPERTIES = LootItemConditions.register("entity_properties", LootItemConditionEntityProperty.CODEC);
    public static final LootItemConditionType KILLED_BY_PLAYER = LootItemConditions.register("killed_by_player", LootItemConditionKilledByPlayer.CODEC);
    public static final LootItemConditionType ENTITY_SCORES = LootItemConditions.register("entity_scores", LootItemConditionEntityScore.CODEC);
    public static final LootItemConditionType BLOCK_STATE_PROPERTY = LootItemConditions.register("block_state_property", LootItemConditionBlockStateProperty.CODEC);
    public static final LootItemConditionType MATCH_TOOL = LootItemConditions.register("match_tool", LootItemConditionMatchTool.CODEC);
    public static final LootItemConditionType TABLE_BONUS = LootItemConditions.register("table_bonus", LootItemConditionTableBonus.CODEC);
    public static final LootItemConditionType SURVIVES_EXPLOSION = LootItemConditions.register("survives_explosion", LootItemConditionSurvivesExplosion.CODEC);
    public static final LootItemConditionType DAMAGE_SOURCE_PROPERTIES = LootItemConditions.register("damage_source_properties", LootItemConditionDamageSourceProperties.CODEC);
    public static final LootItemConditionType LOCATION_CHECK = LootItemConditions.register("location_check", LootItemConditionLocationCheck.CODEC);
    public static final LootItemConditionType WEATHER_CHECK = LootItemConditions.register("weather_check", LootItemConditionWeatherCheck.CODEC);
    public static final LootItemConditionType REFERENCE = LootItemConditions.register("reference", LootItemConditionReference.CODEC);
    public static final LootItemConditionType TIME_CHECK = LootItemConditions.register("time_check", LootItemConditionTimeCheck.CODEC);
    public static final LootItemConditionType VALUE_CHECK = LootItemConditions.register("value_check", ValueCheckCondition.CODEC);
    public static final LootItemConditionType ENCHANTMENT_ACTIVE_CHECK = LootItemConditions.register("enchantment_active_check", EnchantmentActiveCheck.CODEC);

    private static LootItemConditionType register(String var0, MapCodec<? extends LootItemCondition> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_CONDITION_TYPE, MinecraftKey.withDefaultNamespace(var0), new LootItemConditionType(var1));
    }
}

