/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.Vec3D;

public class MovingObjectPositionBlock
extends MovingObjectPosition {
    private final EnumDirection direction;
    private final BlockPosition blockPos;
    private final boolean miss;
    private final boolean inside;
    private final boolean worldBorderHit;

    public static MovingObjectPositionBlock miss(Vec3D var0, EnumDirection var1, BlockPosition var2) {
        return new MovingObjectPositionBlock(true, var0, var1, var2, false, false);
    }

    public MovingObjectPositionBlock(Vec3D var0, EnumDirection var1, BlockPosition var2, boolean var3) {
        this(false, var0, var1, var2, var3, false);
    }

    public MovingObjectPositionBlock(Vec3D var0, EnumDirection var1, BlockPosition var2, boolean var3, boolean var4) {
        this(false, var0, var1, var2, var3, var4);
    }

    private MovingObjectPositionBlock(boolean var0, Vec3D var1, EnumDirection var2, BlockPosition var3, boolean var4, boolean var5) {
        super(var1);
        this.miss = var0;
        this.direction = var2;
        this.blockPos = var3;
        this.inside = var4;
        this.worldBorderHit = var5;
    }

    public MovingObjectPositionBlock withDirection(EnumDirection var0) {
        return new MovingObjectPositionBlock(this.miss, this.location, var0, this.blockPos, this.inside, this.worldBorderHit);
    }

    public MovingObjectPositionBlock withPosition(BlockPosition var0) {
        return new MovingObjectPositionBlock(this.miss, this.location, this.direction, var0, this.inside, this.worldBorderHit);
    }

    public MovingObjectPositionBlock hitBorder() {
        return new MovingObjectPositionBlock(this.miss, this.location, this.direction, this.blockPos, this.inside, true);
    }

    public BlockPosition getBlockPos() {
        return this.blockPos;
    }

    public EnumDirection getDirection() {
        return this.direction;
    }

    @Override
    public MovingObjectPosition.EnumMovingObjectType getType() {
        return this.miss ? MovingObjectPosition.EnumMovingObjectType.MISS : MovingObjectPosition.EnumMovingObjectType.BLOCK;
    }

    public boolean isInside() {
        return this.inside;
    }

    public boolean isWorldBorderHit() {
        return this.worldBorderHit;
    }
}

