/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SystemUtils;

public class Vec2F {
    public static final Vec2F ZERO = new Vec2F(0.0f, 0.0f);
    public static final Vec2F ONE = new Vec2F(1.0f, 1.0f);
    public static final Vec2F UNIT_X = new Vec2F(1.0f, 0.0f);
    public static final Vec2F NEG_UNIT_X = new Vec2F(-1.0f, 0.0f);
    public static final Vec2F UNIT_Y = new Vec2F(0.0f, 1.0f);
    public static final Vec2F NEG_UNIT_Y = new Vec2F(0.0f, -1.0f);
    public static final Vec2F MAX = new Vec2F(Float.MAX_VALUE, Float.MAX_VALUE);
    public static final Vec2F MIN = new Vec2F(Float.MIN_VALUE, Float.MIN_VALUE);
    public static final Codec<Vec2F> CODEC = Codec.FLOAT.listOf().comapFlatMap(var02 -> SystemUtils.fixedSize(var02, 2).map(var0 -> new Vec2F(((Float)var0.get(0)).floatValue(), ((Float)var0.get(1)).floatValue())), var0 -> List.of(Float.valueOf(var0.x), Float.valueOf(var0.y)));
    public final float x;
    public final float y;

    public Vec2F(float var0, float var1) {
        this.x = var0;
        this.y = var1;
    }

    public Vec2F scale(float var0) {
        return new Vec2F(this.x * var0, this.y * var0);
    }

    public float dot(Vec2F var0) {
        return this.x * var0.x + this.y * var0.y;
    }

    public Vec2F add(Vec2F var0) {
        return new Vec2F(this.x + var0.x, this.y + var0.y);
    }

    public Vec2F add(float var0) {
        return new Vec2F(this.x + var0, this.y + var0);
    }

    public boolean equals(Vec2F var0) {
        return this.x == var0.x && this.y == var0.y;
    }

    public Vec2F normalized() {
        float var0 = MathHelper.sqrt(this.x * this.x + this.y * this.y);
        return var0 < 1.0E-4f ? ZERO : new Vec2F(this.x / var0, this.y / var0);
    }

    public float length() {
        return MathHelper.sqrt(this.x * this.x + this.y * this.y);
    }

    public float lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public float distanceToSqr(Vec2F var0) {
        float var1 = var0.x - this.x;
        float var2 = var0.y - this.y;
        return var1 * var1 + var2 * var2;
    }

    public Vec2F negated() {
        return new Vec2F(-this.x, -this.y);
    }
}

