/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import net.minecraft.world.phys.shapes.VoxelShapeCubePoint;
import net.minecraft.world.phys.shapes.VoxelShapeMerger;
import net.minecraft.world.phys.shapes.VoxelShapes;

public final class VoxelShapeCubeMerger
implements VoxelShapeMerger {
    private final VoxelShapeCubePoint result;
    private final int firstDiv;
    private final int secondDiv;

    VoxelShapeCubeMerger(int var0, int var1) {
        this.result = new VoxelShapeCubePoint((int)VoxelShapes.lcm(var0, var1));
        int var2 = IntMath.gcd((int)var0, (int)var1);
        this.firstDiv = var0 / var2;
        this.secondDiv = var1 / var2;
    }

    @Override
    public boolean forMergedIndexes(VoxelShapeMerger.a var0) {
        int var1 = this.result.size() - 1;
        for (int var2 = 0; var2 < var1; ++var2) {
            if (var0.merge(var2 / this.secondDiv, var2 / this.firstDiv, var2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int size() {
        return this.result.size();
    }

    @Override
    public DoubleList getList() {
        return this.result;
    }
}

