/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.math;

import com.mojang.math.SymmetricGroup3;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Util;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Vector3i;
import org.jspecify.annotations.Nullable;

public enum OctahedralGroup implements StringRepresentable
{
    IDENTITY("identity", SymmetricGroup3.P123, false, false, false),
    ROT_180_FACE_XY("rot_180_face_xy", SymmetricGroup3.P123, true, true, false),
    ROT_180_FACE_XZ("rot_180_face_xz", SymmetricGroup3.P123, true, false, true),
    ROT_180_FACE_YZ("rot_180_face_yz", SymmetricGroup3.P123, false, true, true),
    ROT_120_NNN("rot_120_nnn", SymmetricGroup3.P231, false, false, false),
    ROT_120_NNP("rot_120_nnp", SymmetricGroup3.P312, true, false, true),
    ROT_120_NPN("rot_120_npn", SymmetricGroup3.P312, false, true, true),
    ROT_120_NPP("rot_120_npp", SymmetricGroup3.P231, true, false, true),
    ROT_120_PNN("rot_120_pnn", SymmetricGroup3.P312, true, true, false),
    ROT_120_PNP("rot_120_pnp", SymmetricGroup3.P231, true, true, false),
    ROT_120_PPN("rot_120_ppn", SymmetricGroup3.P231, false, true, true),
    ROT_120_PPP("rot_120_ppp", SymmetricGroup3.P312, false, false, false),
    ROT_180_EDGE_XY_NEG("rot_180_edge_xy_neg", SymmetricGroup3.P213, true, true, true),
    ROT_180_EDGE_XY_POS("rot_180_edge_xy_pos", SymmetricGroup3.P213, false, false, true),
    ROT_180_EDGE_XZ_NEG("rot_180_edge_xz_neg", SymmetricGroup3.P321, true, true, true),
    ROT_180_EDGE_XZ_POS("rot_180_edge_xz_pos", SymmetricGroup3.P321, false, true, false),
    ROT_180_EDGE_YZ_NEG("rot_180_edge_yz_neg", SymmetricGroup3.P132, true, true, true),
    ROT_180_EDGE_YZ_POS("rot_180_edge_yz_pos", SymmetricGroup3.P132, true, false, false),
    ROT_90_X_NEG("rot_90_x_neg", SymmetricGroup3.P132, false, false, true),
    ROT_90_X_POS("rot_90_x_pos", SymmetricGroup3.P132, false, true, false),
    ROT_90_Y_NEG("rot_90_y_neg", SymmetricGroup3.P321, true, false, false),
    ROT_90_Y_POS("rot_90_y_pos", SymmetricGroup3.P321, false, false, true),
    ROT_90_Z_NEG("rot_90_z_neg", SymmetricGroup3.P213, false, true, false),
    ROT_90_Z_POS("rot_90_z_pos", SymmetricGroup3.P213, true, false, false),
    INVERSION("inversion", SymmetricGroup3.P123, true, true, true),
    INVERT_X("invert_x", SymmetricGroup3.P123, true, false, false),
    INVERT_Y("invert_y", SymmetricGroup3.P123, false, true, false),
    INVERT_Z("invert_z", SymmetricGroup3.P123, false, false, true),
    ROT_60_REF_NNN("rot_60_ref_nnn", SymmetricGroup3.P312, true, true, true),
    ROT_60_REF_NNP("rot_60_ref_nnp", SymmetricGroup3.P231, true, false, false),
    ROT_60_REF_NPN("rot_60_ref_npn", SymmetricGroup3.P231, false, false, true),
    ROT_60_REF_NPP("rot_60_ref_npp", SymmetricGroup3.P312, false, false, true),
    ROT_60_REF_PNN("rot_60_ref_pnn", SymmetricGroup3.P231, false, true, false),
    ROT_60_REF_PNP("rot_60_ref_pnp", SymmetricGroup3.P312, true, false, false),
    ROT_60_REF_PPN("rot_60_ref_ppn", SymmetricGroup3.P312, false, true, false),
    ROT_60_REF_PPP("rot_60_ref_ppp", SymmetricGroup3.P231, true, true, true),
    SWAP_XY("swap_xy", SymmetricGroup3.P213, false, false, false),
    SWAP_YZ("swap_yz", SymmetricGroup3.P132, false, false, false),
    SWAP_XZ("swap_xz", SymmetricGroup3.P321, false, false, false),
    SWAP_NEG_XY("swap_neg_xy", SymmetricGroup3.P213, true, true, false),
    SWAP_NEG_YZ("swap_neg_yz", SymmetricGroup3.P132, false, true, true),
    SWAP_NEG_XZ("swap_neg_xz", SymmetricGroup3.P321, true, false, true),
    ROT_90_REF_X_NEG("rot_90_ref_x_neg", SymmetricGroup3.P132, true, false, true),
    ROT_90_REF_X_POS("rot_90_ref_x_pos", SymmetricGroup3.P132, true, true, false),
    ROT_90_REF_Y_NEG("rot_90_ref_y_neg", SymmetricGroup3.P321, true, true, false),
    ROT_90_REF_Y_POS("rot_90_ref_y_pos", SymmetricGroup3.P321, false, true, true),
    ROT_90_REF_Z_NEG("rot_90_ref_z_neg", SymmetricGroup3.P213, false, true, true),
    ROT_90_REF_Z_POS("rot_90_ref_z_pos", SymmetricGroup3.P213, true, false, true);

    public static final OctahedralGroup BLOCK_ROT_X_270;
    public static final OctahedralGroup BLOCK_ROT_X_180;
    public static final OctahedralGroup BLOCK_ROT_X_90;
    public static final OctahedralGroup BLOCK_ROT_Y_270;
    public static final OctahedralGroup BLOCK_ROT_Y_180;
    public static final OctahedralGroup BLOCK_ROT_Y_90;
    public static final OctahedralGroup BLOCK_ROT_Z_270;
    public static final OctahedralGroup BLOCK_ROT_Z_180;
    public static final OctahedralGroup BLOCK_ROT_Z_90;
    private final Matrix3fc transformation;
    private final String name;
    private @Nullable Map<Direction, Direction> rotatedDirections;
    private final boolean invertX;
    private final boolean invertY;
    private final boolean invertZ;
    private final SymmetricGroup3 permutation;
    private static final OctahedralGroup[][] CAYLEY_TABLE;
    private static final OctahedralGroup[] INVERSE_TABLE;

    private OctahedralGroup(String var2, SymmetricGroup3 var3, boolean var4, boolean var5, boolean var6) {
        this.name = var2;
        this.invertX = var4;
        this.invertY = var5;
        this.invertZ = var6;
        this.permutation = var3;
        this.transformation = new Matrix3f().scaling(var4 ? -1.0f : 1.0f, var5 ? -1.0f : 1.0f, var6 ? -1.0f : 1.0f).mul(var3.transformation());
    }

    private static int trace(boolean var0, boolean var1, boolean var2, SymmetricGroup3 var3) {
        int var4 = (var2 ? 4 : 0) + (var1 ? 2 : 0) + (var0 ? 1 : 0);
        return var3.ordinal() << 3 | var4;
    }

    private int trace() {
        return OctahedralGroup.trace(this.invertX, this.invertY, this.invertZ, this.permutation);
    }

    public OctahedralGroup compose(OctahedralGroup var0) {
        return CAYLEY_TABLE[this.ordinal()][var0.ordinal()];
    }

    public OctahedralGroup inverse() {
        return INVERSE_TABLE[this.ordinal()];
    }

    public Matrix3fc transformation() {
        return this.transformation;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    public Direction rotate(Direction var02) {
        if (this.rotatedDirections == null) {
            this.rotatedDirections = Util.makeEnumMap(Direction.class, var0 -> {
                Direction.Axis var1 = var0.getAxis();
                Direction.AxisDirection var2 = var0.getAxisDirection();
                Direction.Axis var3 = this.permutation.inverse().permuteAxis(var1);
                Direction.AxisDirection var4 = this.inverts(var3) ? var2.opposite() : var2;
                return Direction.fromAxisAndDirection(var3, var4);
            });
        }
        return this.rotatedDirections.get(var02);
    }

    public Vector3i rotate(Vector3i var0) {
        this.permutation.permuteVector(var0);
        var0.x = var0.x * (this.invertX ? -1 : 1);
        var0.y = var0.y * (this.invertY ? -1 : 1);
        var0.z = var0.z * (this.invertZ ? -1 : 1);
        return var0;
    }

    public boolean inverts(Direction.Axis var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.X -> this.invertX;
            case Direction.Axis.Y -> this.invertY;
            case Direction.Axis.Z -> this.invertZ;
        };
    }

    public SymmetricGroup3 permutation() {
        return this.permutation;
    }

    public FrontAndTop rotate(FrontAndTop var0) {
        return FrontAndTop.fromFrontAndTop(this.rotate(var0.front()), this.rotate(var0.top()));
    }

    static {
        BLOCK_ROT_X_270 = ROT_90_X_POS;
        BLOCK_ROT_X_180 = ROT_180_FACE_YZ;
        BLOCK_ROT_X_90 = ROT_90_X_NEG;
        BLOCK_ROT_Y_270 = ROT_90_Y_POS;
        BLOCK_ROT_Y_180 = ROT_180_FACE_XZ;
        BLOCK_ROT_Y_90 = ROT_90_Y_NEG;
        BLOCK_ROT_Z_270 = ROT_90_Z_POS;
        BLOCK_ROT_Z_180 = ROT_180_FACE_XY;
        BLOCK_ROT_Z_90 = ROT_90_Z_NEG;
        CAYLEY_TABLE = Util.make(() -> {
            OctahedralGroup[] var02 = OctahedralGroup.values();
            OctahedralGroup[][] var1 = new OctahedralGroup[var02.length][var02.length];
            Map<Integer, OctahedralGroup> var2 = Arrays.stream(var02).collect(Collectors.toMap(OctahedralGroup::trace, var0 -> var0));
            for (OctahedralGroup var6 : var02) {
                for (OctahedralGroup var10 : var02) {
                    SymmetricGroup3 var11 = var10.permutation.compose(var6.permutation);
                    boolean var12 = var6.inverts(Direction.Axis.X) ^ var10.inverts(var6.permutation.permuteAxis(Direction.Axis.X));
                    boolean var13 = var6.inverts(Direction.Axis.Y) ^ var10.inverts(var6.permutation.permuteAxis(Direction.Axis.Y));
                    boolean var14 = var6.inverts(Direction.Axis.Z) ^ var10.inverts(var6.permutation.permuteAxis(Direction.Axis.Z));
                    var1[var6.ordinal()][var10.ordinal()] = var2.get(OctahedralGroup.trace(var12, var13, var14, var11));
                }
            }
            return var1;
        });
        INVERSE_TABLE = (OctahedralGroup[])Arrays.stream(OctahedralGroup.values()).map(var0 -> Arrays.stream(OctahedralGroup.values()).filter(var1 -> var0.compose((OctahedralGroup)var1) == IDENTITY).findAny().get()).toArray(OctahedralGroup[]::new);
    }
}

