/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CacheableFunction;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.functions.CommandFunction;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record AdvancementRewards(int experience, List<ResourceKey<LootTable>> loot, List<ResourceKey<Recipe<?>>> recipes, Optional<CacheableFunction> function) {
    public static final Codec<AdvancementRewards> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.optionalFieldOf("experience", (Object)0).forGetter(AdvancementRewards::experience), (App)LootTable.KEY_CODEC.listOf().optionalFieldOf("loot", List.of()).forGetter(AdvancementRewards::loot), (App)Recipe.KEY_CODEC.listOf().optionalFieldOf("recipes", List.of()).forGetter(AdvancementRewards::recipes), (App)CacheableFunction.CODEC.optionalFieldOf("function").forGetter(AdvancementRewards::function)).apply((Applicative)var0, AdvancementRewards::new));
    public static final AdvancementRewards EMPTY = new AdvancementRewards(0, List.of(), List.of(), Optional.empty());

    public void grant(ServerPlayer var0) {
        var0.giveExperiencePoints(this.experience);
        ServerLevel var12 = var0.level();
        MinecraftServer var22 = var12.getServer();
        LootParams var3 = new LootParams.Builder(var12).withParameter(LootContextParams.THIS_ENTITY, var0).withParameter(LootContextParams.ORIGIN, var0.position()).create(LootContextParamSets.ADVANCEMENT_REWARD);
        boolean var4 = false;
        for (ResourceKey<LootTable> var6 : this.loot) {
            for (ItemStack var8 : var22.reloadableRegistries().getLootTable(var6).getRandomItems(var3)) {
                if (var0.addItem(var8)) {
                    var12.playSound(null, var0.getX(), var0.getY(), var0.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, ((var0.getRandom().nextFloat() - var0.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f);
                    var4 = true;
                    continue;
                }
                ItemEntity var9 = var0.drop(var8, false);
                if (var9 == null) continue;
                var9.setNoPickUpDelay();
                var9.setTarget(var0.getUUID());
            }
        }
        if (var4) {
            var0.containerMenu.broadcastChanges();
        }
        if (!this.recipes.isEmpty()) {
            var0.awardRecipesByKey(this.recipes);
        }
        this.function.flatMap(var1 -> var1.get(var22.getFunctions())).ifPresent(var2 -> var22.getFunctions().execute((CommandFunction<CommandSourceStack>)var2, var0.createCommandSourceStack().withSuppressedOutput().withPermission(LevelBasedPermissionSet.GAMEMASTER)));
    }

    public static class Builder {
        private int experience;
        private final ImmutableList.Builder<ResourceKey<LootTable>> loot = ImmutableList.builder();
        private final ImmutableList.Builder<ResourceKey<Recipe<?>>> recipes = ImmutableList.builder();
        private Optional<Identifier> function = Optional.empty();

        public static Builder experience(int var0) {
            return new Builder().addExperience(var0);
        }

        public Builder addExperience(int var0) {
            this.experience += var0;
            return this;
        }

        public static Builder loot(ResourceKey<LootTable> var0) {
            return new Builder().addLootTable(var0);
        }

        public Builder addLootTable(ResourceKey<LootTable> var0) {
            this.loot.add(var0);
            return this;
        }

        public static Builder recipe(ResourceKey<Recipe<?>> var0) {
            return new Builder().addRecipe(var0);
        }

        public Builder addRecipe(ResourceKey<Recipe<?>> var0) {
            this.recipes.add(var0);
            return this;
        }

        public static Builder function(Identifier var0) {
            return new Builder().runs(var0);
        }

        public Builder runs(Identifier var0) {
            this.function = Optional.of(var0);
            return this;
        }

        public AdvancementRewards build() {
            return new AdvancementRewards(this.experience, (List<ResourceKey<LootTable>>)this.loot.build(), (List<ResourceKey<Recipe<?>>>)this.recipes.build(), this.function.map(CacheableFunction::new));
        }
    }
}

